/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.sftp.attrs;

import com.jn.langx.util.enums.base.CommonEnum;
import com.jn.langx.util.enums.base.EnumDelegate;

public enum FileType implements CommonEnum
{
    BLOCK_SPECIAL(24576, "BLOCK_DEVICE", "b"),
    CHAR_SPECIAL(8192, "CHAR_DEVICE", "c"),
    FIFO_SPECIAL(4096, "FIFO", "p"),
    SOCKET_SPECIAL(49152, "SOCKET", "s"),
    REGULAR(32768, "REGULAR", "-"),
    DIRECTORY(16384, "DIRECTORY", "d"),
    SYMBOLIC_LINK(40960, "SYMBOLIC_LINK", "l"),
    UNKNOWN(0, "UNKNOWN", "unknown");

    private final EnumDelegate delegate;

    private FileType(int val, String name, String displayText) {
        this.delegate = new EnumDelegate(val, name, displayText);
    }

    public static FileType fromMask(int mask) {
        for (FileType t : FileType.values()) {
            if (t.getMask() != mask) continue;
            return t;
        }
        return UNKNOWN;
    }

    public int getMask() {
        return this.getCode();
    }

    public int getCode() {
        return this.delegate.getCode();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getDisplayText() {
        return this.delegate.getDisplayText();
    }
}

