/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.sftp;

import com.jn.agileway.ssh.client.sftp.SftpFile;
import com.jn.langx.util.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class SftpFileOutputStream
extends OutputStream {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final SftpFile sftpFile;
    private long filePosition = 0L;
    private final ByteBuffer byteBuffer;

    public SftpFileOutputStream(SftpFile sftpFile) {
        this(sftpFile, 8192);
    }

    public SftpFileOutputStream(SftpFile sftpFile, int bufferSize) {
        this(sftpFile, bufferSize, 0L);
    }

    public SftpFileOutputStream(SftpFile sftpFile, int bufferSize, long filePosition) {
        Preconditions.checkNotNull((Object)sftpFile);
        this.sftpFile = sftpFile;
        if (bufferSize <= 0) {
            bufferSize = 8192;
        }
        this.byteBuffer = ByteBuffer.allocate(bufferSize);
        Preconditions.checkTrue((filePosition >= 0L ? 1 : 0) != 0);
        this.filePosition = filePosition;
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.byteBuffer.hasRemaining()) {
            this.doFlush();
        }
        this.byteBuffer.put((byte)b);
    }

    private void doFlush() throws IOException {
        this.byteBuffer.flip();
        this.sftpFile.write(this.filePosition, this.byteBuffer.array(), this.byteBuffer.position(), this.byteBuffer.limit());
        this.filePosition += (long)this.byteBuffer.limit();
        this.byteBuffer.clear();
    }

    @Override
    public void flush() throws IOException {
        this.doFlush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.sftpFile.close();
    }
}

