/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.sftp;

import com.jn.langx.util.enums.base.CommonEnum;
import com.jn.langx.util.enums.base.EnumDelegate;

public enum OpenMode implements CommonEnum
{
    READ(1, "r", "read"),
    WRITE(26, "w", "write"),
    APPEND(14, "a", "append"),
    READ_PLUS(3, "r+", "read plus"),
    WRITE_PLUS(27, "w+", "write plus"),
    APPEND_PLUS(15, "a+", "append plus");

    private EnumDelegate delegate;
    private static final int SSH_FXP_READ = 1;
    private static final int SSH_FXP_WRITE = 2;
    private static final int SSH_FXP_APPEND = 4;
    private static final int SSH_FXP_CREATE = 8;
    private static final int SSH_FXP_TRUNCATE = 16;
    private static final int SSH_FXP_EXCL = 32;

    private OpenMode(int code, String name, String displayText) {
        this.delegate = new EnumDelegate(code, name, displayText);
    }

    public int getCode() {
        return this.delegate.getCode();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getDisplayText() {
        return this.delegate.getDisplayText();
    }

    public boolean isAppended() {
        return OpenMode.isAppended(this.getCode());
    }

    public static boolean isAppended(int mode) {
        return (mode & 4) == 4;
    }

    public boolean isTruncated() {
        return OpenMode.isTruncated(this.getCode());
    }

    public static boolean isTruncated(int mode) {
        return (mode & 0x10) == 16;
    }

    public boolean isCreatable() {
        return OpenMode.isCreatable(this.getCode());
    }

    public static boolean isCreatable(int mode) {
        return (mode & 8) == 8;
    }

    public boolean isReadable() {
        return OpenMode.isReadable(this.getCode());
    }

    public static boolean isReadable(int mode) {
        return (mode & 1) == 1;
    }

    public boolean isWritable() {
        return OpenMode.isWritable(this.getCode());
    }

    public static boolean isWritable(int mode) {
        return (mode & 2) == 2;
    }

    public static boolean willFailWhenCreateExist(int mode) {
        return (mode & 0x20) == 32;
    }
}

