/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.impl.trileadssh2.verifier;

import com.jn.agileway.ssh.client.transport.hostkey.StrictHostKeyChecking;
import com.jn.agileway.ssh.client.transport.hostkey.knownhosts.KnownHostsFiles;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.logging.Loggers;
import com.trilead.ssh2.KnownHosts;
import com.trilead.ssh2.ServerHostKeyVerifier;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;

public class KnownHostsVerifier
implements ServerHostKeyVerifier {
    private static final Logger logger = Loggers.getLogger(KnownHostsVerifier.class);
    private final KnownHosts knownHosts = new KnownHosts();
    private final List<File> knownHostsFiles = Collects.emptyArrayList();
    private static final List<String> supportedAlgorithms = Collects.immutableArrayList((Object[])new String[]{"ssh-rsa", "ssh-dss"});
    private StrictHostKeyChecking strictHostKeyChecking;

    public KnownHostsVerifier(List<File> files) {
        Collects.forEach(files, (Consumer)new Consumer<File>(){

            public void accept(File file) {
                try {
                    KnownHostsVerifier.this.knownHosts.addHostkeys(file);
                    KnownHostsVerifier.this.knownHostsFiles.add(file);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    public StrictHostKeyChecking getStrictHostKeyChecking() {
        return this.strictHostKeyChecking;
    }

    public void setStrictHostKeyChecking(StrictHostKeyChecking strictHostKeyChecking) {
        this.strictHostKeyChecking = strictHostKeyChecking;
    }

    public boolean verifyServerHostKey(final String hostname, int port, final String serverHostKeyAlgorithm, final byte[] serverHostKey) throws Exception {
        int result = this.knownHosts.verifyHostkey(hostname, serverHostKeyAlgorithm, serverHostKey);
        if (result == 0) {
            return true;
        }
        if (!supportedAlgorithms.contains(serverHostKeyAlgorithm)) {
            return true;
        }
        if (result == 1) {
            Collects.forEach(this.knownHostsFiles, (Consumer)new Consumer<File>(){

                public void accept(File file) {
                    try {
                        KnownHostsVerifier.this.knownHosts.addHostkey(new String[]{hostname}, serverHostKeyAlgorithm, serverHostKey);
                        KnownHostsFiles.appendHostKeysToFile(file, new String[]{hostname}, serverHostKeyAlgorithm, serverHostKey);
                    }
                    catch (Throwable ex) {
                        logger.error("write to known_hosts file {} fail, error: {}", new Object[]{file.getPath(), ex.getMessage(), ex});
                    }
                }
            });
            return true;
        }
        return result == 2;
    }
}

