/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.impl.trileadssh2.sftp;

import com.jn.agileway.ssh.client.impl.trileadssh2.sftp.Ssh2SftpFile;
import com.jn.agileway.ssh.client.impl.trileadssh2.sftp.Ssh2Sftps;
import com.jn.agileway.ssh.client.sftp.AbstractSftpSession;
import com.jn.agileway.ssh.client.sftp.OpenMode;
import com.jn.agileway.ssh.client.sftp.SftpFile;
import com.jn.agileway.ssh.client.sftp.SftpResourceInfo;
import com.jn.agileway.ssh.client.sftp.Sftps;
import com.jn.agileway.ssh.client.sftp.attrs.FileAttrs;
import com.jn.agileway.ssh.client.sftp.attrs.FileMode;
import com.jn.agileway.ssh.client.sftp.attrs.FileType;
import com.jn.agileway.ssh.client.sftp.exception.NoSuchFileSftpException;
import com.jn.agileway.ssh.client.sftp.exception.SftpException;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Predicate;
import com.trilead.ssh2.SFTPv3Client;
import com.trilead.ssh2.SFTPv3DirectoryEntry;
import com.trilead.ssh2.SFTPv3FileAttributes;
import com.trilead.ssh2.SFTPv3FileHandle;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

public class Ssh2SftpSession
extends AbstractSftpSession {
    private SFTPv3Client sftpClient;

    public Ssh2SftpSession(SFTPv3Client sftpClient) {
        this.sftpClient = sftpClient;
    }

    public SFTPv3Client getSftpClient() {
        return this.sftpClient;
    }

    @Override
    protected List<SftpResourceInfo> doListFiles(final String directory) throws SftpException {
        try {
            Vector vector = this.sftpClient.ls(directory);
            return Pipeline.of((Iterable)vector).filter((Predicate)new Predicate<SFTPv3DirectoryEntry>(){

                public boolean test(SFTPv3DirectoryEntry entry) {
                    return !".".equals(entry.filename) && !"..".equals(entry.filename);
                }
            }).map((Function)new Function<SFTPv3DirectoryEntry, SftpResourceInfo>(){

                public SftpResourceInfo apply(SFTPv3DirectoryEntry entry) {
                    FileAttrs attrs = Ssh2Sftps.fromSsh2FileAttributes(entry.attributes);
                    return new SftpResourceInfo(directory + "/" + entry.filename, attrs);
                }
            }).asList();
        }
        catch (Throwable ex) {
            throw new SftpException(ex);
        }
    }

    @Override
    public int getProtocolVersion() throws SftpException {
        return this.sftpClient.getProtocolVersion();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SftpFile open(String filepath, int openMode, FileAttrs attrs) throws SftpException {
        try {
            SFTPv3FileHandle handle = null;
            if (!Sftps.exists(this, filepath)) {
                FileMode fileMode;
                if (attrs == null) {
                    attrs = new FileAttrs();
                }
                if ((fileMode = attrs.getFileMode()) == null) {
                    fileMode = FileMode.createFileMode(FileType.REGULAR, 420);
                    attrs.setFileMode(fileMode);
                }
                if (!OpenMode.isCreatable(openMode)) throw new NoSuchFileSftpException(StringTemplates.formatWithPlaceholder((String)"no such file: {}", (Object[])new Object[]{filepath}));
                handle = this.sftpClient.createFileTruncate(filepath, Ssh2Sftps.toSsh2FileAttributes(attrs));
            } else if (OpenMode.isTruncated(openMode)) {
                handle = this.sftpClient.createFileTruncate(filepath, Ssh2Sftps.toSsh2FileAttributes(attrs));
            }
            if (handle != null) {
                this.sftpClient.closeFile(handle);
                handle = null;
            }
            handle = OpenMode.isWritable(openMode) ? this.sftpClient.openFileRW(filepath) : this.sftpClient.openFileRO(filepath);
            Ssh2SftpFile sftpFile = new Ssh2SftpFile(this, filepath);
            sftpFile.setFileHandle(handle);
            return sftpFile;
        }
        catch (Throwable ex) {
            throw new SftpException(ex);
        }
    }

    @Override
    public void createSymlink(String src, String target) throws SftpException {
        try {
            this.sftpClient.createSymlink(src, target);
        }
        catch (Throwable ex) {
            throw Ssh2Sftps.wrapSftpException(ex);
        }
    }

    @Override
    public String readLink(String path) throws SftpException {
        try {
            return this.sftpClient.readLink(path);
        }
        catch (Throwable ex) {
            throw Ssh2Sftps.wrapSftpException(ex);
        }
    }

    @Override
    public String canonicalPath(String path) throws SftpException {
        try {
            return this.sftpClient.canonicalPath(path);
        }
        catch (Throwable ex) {
            throw Ssh2Sftps.wrapSftpException(ex);
        }
    }

    @Override
    public FileAttrs stat(String filepath) throws SftpException {
        try {
            SFTPv3FileAttributes attributes = this.sftpClient.stat(filepath);
            return Ssh2Sftps.fromSsh2FileAttributes(attributes);
        }
        catch (Throwable ex) {
            throw Ssh2Sftps.wrapSftpException(ex);
        }
    }

    @Override
    public FileAttrs lstat(String filepath) throws SftpException {
        try {
            SFTPv3FileAttributes attributes = this.sftpClient.lstat(filepath);
            return Ssh2Sftps.fromSsh2FileAttributes(attributes);
        }
        catch (Throwable ex) {
            throw Ssh2Sftps.wrapSftpException(ex);
        }
    }

    @Override
    public void setStat(String path, FileAttrs attrs) throws SftpException {
        try {
            SFTPv3FileAttributes attributes = Ssh2Sftps.toSsh2FileAttributes(attrs);
            this.sftpClient.setstat(path, attributes);
        }
        catch (Throwable ex) {
            throw Ssh2Sftps.wrapSftpException(ex);
        }
    }

    @Override
    public void mkdir(String directory, FileAttrs attributes) throws SftpException {
        try {
            FileMode fileMode = attributes == null ? null : attributes.getFileMode();
            int permissions = fileMode == null ? 509 : fileMode.getMask();
            this.sftpClient.mkdir(directory, permissions);
        }
        catch (Throwable ex) {
            throw Ssh2Sftps.wrapSftpException(ex);
        }
    }

    @Override
    public void rmdir(String directory) throws SftpException {
        try {
            this.sftpClient.rmdir(directory);
        }
        catch (Throwable ex) {
            throw Ssh2Sftps.wrapSftpException(ex);
        }
    }

    @Override
    public void rm(String filepath) throws SftpException {
        try {
            this.sftpClient.rm(filepath);
        }
        catch (Throwable ex) {
            throw Ssh2Sftps.wrapSftpException(ex);
        }
    }

    @Override
    public void mv(String oldFilepath, String newFilepath) throws SftpException {
        try {
            this.sftpClient.mv(oldFilepath, newFilepath);
        }
        catch (Throwable ex) {
            throw Ssh2Sftps.wrapSftpException(ex);
        }
    }

    @Override
    public void close() throws IOException {
        this.sftpClient.close();
    }
}

