/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.impl.synergy.sftp;

import com.jn.agileway.ssh.client.sftp.OpenMode;
import com.jn.agileway.ssh.client.sftp.attrs.FileAttrs;
import com.jn.agileway.ssh.client.sftp.attrs.FileMode;
import com.jn.agileway.ssh.client.sftp.attrs.FileType;
import com.jn.langx.util.Numbers;
import com.sshtools.common.sftp.SftpFileAttributes;
import com.sshtools.common.util.UnsignedInteger32;
import com.sshtools.common.util.UnsignedInteger64;

class SynergySftps {
    SynergySftps() {
    }

    public static int toOpenFlags(OpenMode openMode) {
        return openMode.getCode();
    }

    public static FileAttrs fromSftpFileAttributes(SftpFileAttributes attributes) {
        String gid;
        String uid;
        if (attributes == null) {
            return null;
        }
        FileAttrs attrs = new FileAttrs();
        if (attributes.hasSize()) {
            attrs.setSize(attributes.getSize().longValue());
        }
        if (attributes.hasAccessTime()) {
            attrs.setAccessTime(attributes.getAccessedTime().bigIntValue().intValue());
        }
        if (attributes.hasModifiedTime()) {
            attrs.setModifyTime(attributes.getModifiedTime().bigIntValue().intValue());
        }
        if (attributes.hasUID() && Numbers.isNumber((String)(uid = attributes.getUID()))) {
            attrs.setUid(Integer.parseInt(uid));
        }
        if (attributes.hasGID() && Numbers.isNumber((String)(gid = attributes.getGID()))) {
            attrs.setGid(Integer.parseInt(gid));
        }
        FileType fileType = FileType.UNKNOWN;
        if (attributes.isFile()) {
            fileType = FileType.REGULAR;
        } else if (attributes.isDirectory()) {
            fileType = FileType.DIRECTORY;
        } else if (attributes.isBlock()) {
            fileType = FileType.BLOCK_SPECIAL;
        } else if (attributes.isCharacter()) {
            fileType = FileType.CHAR_SPECIAL;
        } else if (attributes.isFifo()) {
            fileType = FileType.FIFO_SPECIAL;
        } else if (attributes.isSocket()) {
            fileType = FileType.SOCKET_SPECIAL;
        } else if (attributes.isLink()) {
            fileType = FileType.SYMBOLIC_LINK;
        }
        int permissions = attributes.getPermissions().intValue();
        FileMode fileMode = FileMode.createFileMode(fileType, permissions);
        attrs.setFileMode(fileMode);
        return attrs;
    }

    public static SftpFileAttributes toSftpFileAttributes(FileAttrs attrs, String encoding) {
        int fileType = 5;
        switch (attrs.getFileType()) {
            case REGULAR: {
                fileType = 1;
                break;
            }
            case DIRECTORY: {
                fileType = 2;
                break;
            }
            case SYMBOLIC_LINK: {
                fileType = 3;
                break;
            }
            case FIFO_SPECIAL: {
                fileType = 9;
                break;
            }
            case BLOCK_SPECIAL: {
                fileType = 8;
                break;
            }
            case CHAR_SPECIAL: {
                fileType = 7;
                break;
            }
            case SOCKET_SPECIAL: {
                fileType = 6;
                break;
            }
        }
        SftpFileAttributes attributes = new SftpFileAttributes(fileType, encoding);
        if (attrs.getSize() != null) {
            attributes.setSize(new UnsignedInteger64(attrs.getSize().longValue()));
        }
        UnsignedInteger64 atime = null;
        UnsignedInteger64 mtime = null;
        if (attrs.getAccessTime() != null) {
            atime = new UnsignedInteger64((long)attrs.getAccessTime().intValue());
        }
        if (attrs.getModifyTime() != null) {
            mtime = new UnsignedInteger64((long)attrs.getModifyTime().intValue());
        }
        attributes.setTimes(atime, mtime);
        if (attrs.getGid() != null) {
            attributes.setGID(attrs.getGid().toString());
        }
        if (attrs.getUid() != null) {
            attributes.setUID(attrs.getUid().toString());
        }
        FileMode fileMode = attrs.getFileMode();
        attributes.setPermissions(new UnsignedInteger32((long)fileMode.getPermissionsMask()));
        return attributes;
    }
}

