/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.impl.sshj.sftp;

import com.jn.agileway.ssh.client.impl.sshj.sftp.SshjSftpFile;
import com.jn.agileway.ssh.client.impl.sshj.sftp.SshjSftps;
import com.jn.agileway.ssh.client.sftp.AbstractSftpSession;
import com.jn.agileway.ssh.client.sftp.SftpFile;
import com.jn.agileway.ssh.client.sftp.SftpResourceInfo;
import com.jn.agileway.ssh.client.sftp.attrs.FileAttrs;
import com.jn.agileway.ssh.client.sftp.exception.SftpException;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Predicate;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.sftp.SFTPException;

public class SshjSftpSession
extends AbstractSftpSession {
    private SFTPClient sftpClient;

    public SshjSftpSession(SFTPClient client) {
        this.sftpClient = client;
    }

    @Override
    public int getProtocolVersion() throws SftpException {
        return this.sftpClient.version();
    }

    @Override
    public SftpFile open(String filepath, int openMode, FileAttrs attrs) throws SftpException {
        try {
            Set<OpenMode> openModes = SshjSftps.toSshjOpenModeSet(openMode);
            FileAttributes attributes = SshjSftps.toFileAttributes(attrs);
            RemoteFile remoteFile = this.sftpClient.open(filepath, openModes, attributes);
            SshjSftpFile file = new SshjSftpFile(this, filepath);
            file.setRemoteFile(remoteFile);
            return file;
        }
        catch (Throwable ex) {
            throw SshjSftps.wrapSftpException(ex);
        }
    }

    @Override
    public void createSymlink(String src, String target) throws SftpException {
        try {
            this.sftpClient.symlink(src, target);
        }
        catch (Throwable ex) {
            throw SshjSftps.wrapSftpException(ex);
        }
    }

    @Override
    public String readLink(String path) throws SftpException {
        try {
            return this.sftpClient.readlink(path);
        }
        catch (Throwable ex) {
            throw SshjSftps.wrapSftpException(ex);
        }
    }

    @Override
    public String canonicalPath(String path) throws SftpException {
        try {
            return this.sftpClient.canonicalize(path);
        }
        catch (Throwable ex) {
            throw SshjSftps.wrapSftpException(ex);
        }
    }

    @Override
    public FileAttrs stat(String filepath) throws SftpException {
        try {
            FileAttributes fileAttributes = this.sftpClient.stat(filepath);
            return SshjSftps.fromFileAttributes(fileAttributes);
        }
        catch (Throwable ex) {
            throw SshjSftps.wrapSftpException(ex);
        }
    }

    @Override
    public FileAttrs lstat(String filepath) throws SftpException {
        try {
            FileAttributes fileAttributes = this.sftpClient.lstat(filepath);
            return SshjSftps.fromFileAttributes(fileAttributes);
        }
        catch (Throwable ex) {
            throw SshjSftps.wrapSftpException(ex);
        }
    }

    @Override
    public void setStat(String path, FileAttrs attrs) throws SftpException {
        try {
            this.sftpClient.setattr(path, SshjSftps.toFileAttributes(attrs));
        }
        catch (Throwable ex) {
            throw SshjSftps.wrapSftpException(ex);
        }
    }

    @Override
    protected List<SftpResourceInfo> doListFiles(String directory) throws SftpException {
        try {
            List list = this.sftpClient.ls(directory);
            return Pipeline.of((Iterable)list).filter((Predicate)new Predicate<RemoteResourceInfo>(){

                public boolean test(RemoteResourceInfo remoteResourceInfo) {
                    return !".".equals(remoteResourceInfo.getName()) && !"..".equals(remoteResourceInfo.getName());
                }
            }).map((Function)new Function<RemoteResourceInfo, SftpResourceInfo>(){

                public SftpResourceInfo apply(RemoteResourceInfo remoteResourceInfo) {
                    return SshjSftps.fromRemoteResourceInfo(remoteResourceInfo);
                }
            }).asList();
        }
        catch (Throwable ex) {
            throw SshjSftps.wrapSftpException(ex);
        }
    }

    @Override
    public void mkdir(String directory, FileAttrs attributes) throws SftpException {
        try {
            this.sftpClient.mkdirs(directory);
        }
        catch (Throwable ex) {
            throw SshjSftps.wrapSftpException(ex);
        }
    }

    @Override
    public void rmdir(String directory) throws SftpException {
        try {
            this.sftpClient.rmdir(directory);
        }
        catch (Throwable ex) {
            throw SshjSftps.wrapSftpException(ex);
        }
    }

    @Override
    public void rm(String filepath) throws SftpException {
        try {
            this.sftpClient.rm(filepath);
        }
        catch (Throwable ex) {
            throw SshjSftps.wrapSftpException(ex);
        }
    }

    @Override
    public void mv(String oldFilepath, String newFilepath) throws SftpException {
        try {
            this.sftpClient.rename(oldFilepath, newFilepath);
        }
        catch (Throwable ex) {
            throw SshjSftps.wrapSftpException(ex);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.sftpClient.close();
        }
        catch (SFTPException ex) {
            throw SshjSftps.wrapSftpException(ex);
        }
    }
}

