/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.impl.sshj;

import com.jn.agileway.ssh.client.SshException;
import com.jn.agileway.ssh.client.channel.AbstarctSessionedChannel;
import com.jn.agileway.ssh.client.utils.Signal;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.enums.Enums;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.io.IOs;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import net.schmizz.sshj.connection.channel.direct.PTYMode;
import net.schmizz.sshj.connection.channel.direct.Session;

class SshjSessionedChannel
extends AbstarctSessionedChannel {
    private Session session;
    private Session.Command command;
    private Session.Subsystem subsystem;
    private Session.Shell shell;
    private InputStream inputStream;
    private InputStream errorInputStream;
    private OutputStream outputStream;

    SshjSessionedChannel(@NonNull Session session) {
        Preconditions.checkNotNull((Object)session);
        this.session = session;
    }

    @Override
    public void pty(String term) throws SshException {
        this.pty(term, 0, 0, 0, 0, null);
    }

    @Override
    public void pty(String term, int termWidthCharacters, int termHeightCharacters, int termWidthPixels, int termHeightPixels, Map<com.jn.agileway.ssh.client.utils.PTYMode, Integer> terminalModes) throws SshException {
        final HashMap terminalModeMap = new HashMap();
        Collects.forEach(terminalModes, (Consumer2)new Consumer2<com.jn.agileway.ssh.client.utils.PTYMode, Integer>(){

            public void accept(com.jn.agileway.ssh.client.utils.PTYMode ptyMode, Integer value) {
                String operateName = ptyMode.name();
                PTYMode mode = (PTYMode)Enums.ofName(PTYMode.class, (String)operateName);
                if (mode != null) {
                    terminalModeMap.put(mode, value);
                }
            }
        });
        try {
            this.session.allocatePTY(term, termWidthCharacters, termHeightCharacters, termWidthPixels, termHeightPixels, terminalModeMap);
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
    }

    @Override
    public void env(String variableName, String variableValue) throws SshException {
        try {
            this.session.setEnvVar(variableName, variableValue);
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
    }

    @Override
    protected void internalX11Forwarding(String hostname, int port, boolean singleConnection, String x11AuthenticationProtocol, String x11AuthenticationCookie, int x11ScreenNumber) throws SshException {
        try {
            this.session.reqX11Forwarding(x11AuthenticationProtocol, x11AuthenticationCookie, x11ScreenNumber);
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
    }

    @Override
    protected void internalExec(String command) throws SshException {
        Preconditions.checkNotEmpty((Object)command, (String)"the command is illegal : {}", (Object[])new Object[]{command});
        try {
            this.command = this.session.exec(command);
            this.initStreams();
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
    }

    @Override
    protected void internalSubsystem(String subsystem) throws SshException {
        Preconditions.checkNotEmpty((Object)subsystem, (String)"the subsystem is illegal : {}", (Object[])new Object[]{subsystem});
        try {
            this.subsystem = this.session.startSubsystem(subsystem);
            this.initStreams();
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
    }

    @Override
    protected void internalShell() throws SshException {
        try {
            this.shell = this.session.startShell();
            this.initStreams();
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
    }

    private void initStreams() {
        this.getInputStream();
        this.getErrorInputStream();
        this.getOutputStream();
    }

    private void closeStreams() {
        IOs.close((Object)this.outputStream);
        this.outputStream = null;
        IOs.close((Object)this.inputStream);
        this.inputStream = null;
        IOs.close((Object)this.errorInputStream);
        this.errorInputStream = null;
    }

    @Override
    public void signal(Signal signal) throws SshException {
        Preconditions.checkNotEmpty((Object)((Object)signal), (String)"the signal is null or empty");
        Preconditions.checkArgument((signal != Signal.UNKNOWN ? 1 : 0) != 0, (String)"the signal is UNKNOWN");
        net.schmizz.sshj.connection.channel.direct.Signal sg = null;
        String name = signal.name();
        sg = net.schmizz.sshj.connection.channel.direct.Signal.fromString((String)name);
        try {
            if (this.shell != null) {
                this.shell.signal(sg);
            }
            if (this.command != null) {
                this.command.signal(sg);
            }
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
    }

    @Override
    public void close() throws IOException {
        this.closeStreams();
        this.session.close();
    }

    @Override
    public int getExitStatus() {
        if (this.subsystem != null) {
            long maxWait = 5000L;
            Integer exitStatus = this.subsystem.getExitStatus();
            while (exitStatus == null && maxWait > 0L) {
                try {
                    int timeout = 10;
                    maxWait -= (long)timeout;
                    this.wait(timeout);
                }
                catch (Throwable timeout) {
                    // empty catch block
                }
                exitStatus = this.subsystem.getExitStatus();
            }
            return exitStatus == null ? 0 : exitStatus;
        }
        if (this.command != null) {
            long maxWait = 5000L;
            Integer exitStatus = this.command.getExitStatus();
            while (exitStatus == null && maxWait > 0L) {
                try {
                    int timeout = 10;
                    maxWait -= (long)timeout;
                    this.wait(timeout);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                exitStatus = this.command.getExitStatus();
            }
            return exitStatus == null ? 0 : exitStatus;
        }
        return 0;
    }

    @Override
    public InputStream getErrorInputStream() throws SshException {
        if (this.errorInputStream == null) {
            if (this.shell != null) {
                this.errorInputStream = this.shell.getErrorStream();
            } else if (this.command != null) {
                this.errorInputStream = this.command.getErrorStream();
            }
        }
        return this.errorInputStream;
    }

    @Override
    public InputStream getInputStream() throws SshException {
        if (this.inputStream == null) {
            if (this.shell != null) {
                this.inputStream = this.shell.getInputStream();
            }
            if (this.subsystem != null) {
                this.inputStream = this.subsystem.getInputStream();
            }
            if (this.command != null) {
                this.inputStream = this.command.getInputStream();
            }
        }
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() throws SshException {
        if (this.outputStream == null) {
            if (this.shell != null) {
                this.outputStream = this.shell.getOutputStream();
            }
            if (this.subsystem != null) {
                this.outputStream = this.subsystem.getOutputStream();
            }
            if (this.command != null) {
                this.outputStream = this.command.getOutputStream();
            }
        }
        return this.outputStream;
    }

    @Override
    protected void beforeAction() {
        this.closeStreams();
        this.shell = null;
        this.command = null;
        this.subsystem = null;
    }
}

