/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.impl.sshj;

import com.jn.agileway.ssh.client.SshException;
import com.jn.agileway.ssh.client.channel.forwarding.ForwardingChannelInfo;
import com.jn.agileway.ssh.client.channel.forwarding.ForwardingClient;
import com.jn.agileway.ssh.client.impl.sshj.SshjConnection;
import com.jn.langx.util.ClassLoaders;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.reflect.Reflects;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.LocalPortForwarder;
import net.schmizz.sshj.connection.channel.forwarded.ConnectListener;
import net.schmizz.sshj.connection.channel.forwarded.RemotePortForwarder;
import net.schmizz.sshj.connection.channel.forwarded.SocketForwardingConnectListener;

public class SshjForwardingClient
implements ForwardingClient {
    private static final Class LOCAL_PORT_FORWARDER_PARAMETERS = SshjForwardingClient.findLocalPortForwardingParametersClass();
    private static final Method NEW_LOCAL_PORT_FORWARDER = SshjForwardingClient.findNewLocalPortForwarder(LOCAL_PORT_FORWARDER_PARAMETERS);
    private SshjConnection connection;
    private Map<String, LocalForwardingChannelCtx> localForwardingMap = new HashMap<String, LocalForwardingChannelCtx>();

    SshjForwardingClient(SshjConnection connection) {
        this.connection = connection;
    }

    private static Class findLocalPortForwardingParametersClass() {
        String parametersClassInNetSchmizzJar;
        String parametersClassInHierynomusSshjJar = "net.schmizz.sshj.connection.channel.direct.Parameters";
        ClassLoader expectedClassLoader = SSHClient.class.getClassLoader();
        if (ClassLoaders.hasClass((String)parametersClassInHierynomusSshjJar, (ClassLoader)expectedClassLoader)) {
            try {
                return ClassLoaders.loadClass((String)parametersClassInHierynomusSshjJar, (ClassLoader)expectedClassLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (ClassLoaders.hasClass((String)(parametersClassInNetSchmizzJar = "net.schmizz.sshj.connection.channel.direct.LocalPortForwarder$Parameters"), (ClassLoader)expectedClassLoader)) {
            try {
                return ClassLoaders.loadClass((String)parametersClassInNetSchmizzJar, (ClassLoader)expectedClassLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new IllegalStateException("sshj is error version");
    }

    private static Method findNewLocalPortForwarder(Class parametersClass) {
        return Reflects.getPublicMethod(SSHClient.class, (String)"newLocalPortForwarder", (Class[])new Class[]{parametersClass, ServerSocket.class});
    }

    @Override
    public ForwardingChannelInfo startLocalForwarding(String bindToHost, int bindToPort, String destHost, int destPort) throws SshException {
        SSHClient delegate = this.connection.getDelegate();
        ForwardingChannelInfo channel = new ForwardingChannelInfo("direct-tcpip", bindToHost, bindToPort, destHost, destPort);
        if (!this.localForwardingMap.containsKey(ForwardingChannelInfo.id(channel))) {
            InetSocketAddress address = new InetSocketAddress(bindToHost, bindToPort);
            try {
                ServerSocket serverSocket = new ServerSocket();
                serverSocket.bind(address);
                Object parameters = Reflects.newInstance((Class)LOCAL_PORT_FORWARDER_PARAMETERS, (Class[])new Class[]{String.class, Integer.TYPE, String.class, Integer.TYPE}, (Object[])new Object[]{bindToHost, bindToPort, destHost, destPort});
                final LocalPortForwarder forwarder = (LocalPortForwarder)Reflects.invoke((Method)NEW_LOCAL_PORT_FORWARDER, (Object)delegate, (Object[])new Object[]{parameters, serverSocket}, (boolean)true, (boolean)true);
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        try {
                            forwarder.listen();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                };
                t.start();
                LocalForwardingChannelCtx ctx = new LocalForwardingChannelCtx();
                ctx.thread = t;
                ctx.channel = channel;
                ctx.forwarder = forwarder;
                this.localForwardingMap.put(ForwardingChannelInfo.id(channel), ctx);
            }
            catch (Throwable ex) {
                throw new SshException(ex);
            }
        }
        return channel;
    }

    @Override
    public void stopLocalForwarding(ForwardingChannelInfo channel) throws SshException {
        if (this.localForwardingMap.containsKey(ForwardingChannelInfo.id(channel))) {
            LocalForwardingChannelCtx ctx = this.localForwardingMap.remove(ForwardingChannelInfo.id(channel));
            IOs.close((Object)ctx);
        }
    }

    @Override
    public ForwardingChannelInfo startRemoteForwarding(String bindToHost, int bindToPort, String destHost, int destPort) throws SshException {
        SSHClient delegate = this.connection.getDelegate();
        RemotePortForwarder forwarder = delegate.getRemotePortForwarder();
        RemotePortForwarder.Forward forward = new RemotePortForwarder.Forward(bindToHost, bindToPort);
        try {
            forwarder.bind(forward, (ConnectListener)new SocketForwardingConnectListener((SocketAddress)new InetSocketAddress(bindToHost, bindToPort)));
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
        return new ForwardingChannelInfo("forwarded-tcpip", bindToHost, bindToPort, destHost, destPort);
    }

    @Override
    public void stopRemoteForwarding(ForwardingChannelInfo channel) throws SshException {
        SSHClient delegate = this.connection.getDelegate();
        RemotePortForwarder forwarder = delegate.getRemotePortForwarder();
        RemotePortForwarder.Forward forward = new RemotePortForwarder.Forward(channel.getBindingHost(), channel.getBindingPort());
        try {
            forwarder.cancel(forward);
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
    }

    static class LocalForwardingChannelCtx
    implements Closeable {
        ForwardingChannelInfo channel;
        LocalPortForwarder forwarder;
        Thread thread;

        LocalForwardingChannelCtx() {
        }

        @Override
        public void close() throws IOException {
            this.thread.interrupt();
        }
    }
}

