/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.impl.jsch;

import com.jcraft.jsch.ConfigRepository;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Logger;
import com.jn.agileway.ssh.client.AbstractSshConnectionFactory;
import com.jn.agileway.ssh.client.SshConnection;
import com.jn.agileway.ssh.client.impl.jsch.JschConnection;
import com.jn.agileway.ssh.client.impl.jsch.JschConnectionConfig;
import com.jn.agileway.ssh.client.impl.jsch.JschLoggerToSlf4jLogger;
import com.jn.agileway.ssh.client.impl.jsch.knownhosts.JschKnownHostsKeyRepository;
import com.jn.agileway.ssh.client.transport.hostkey.StrictHostKeyChecking;
import com.jn.agileway.ssh.client.transport.hostkey.knownhosts.OpenSSHKnownHosts;
import com.jn.agileway.ssh.client.transport.hostkey.verifier.PromiscuousHostKeyVerifier;
import com.jn.agileway.ssh.client.utils.SshConfigs;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.annotation.OnClasses;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import java.io.File;
import java.util.List;

@OnClasses(value={"com.jcraft.jsch.JSch"})
public class JschConnectionFactory
extends AbstractSshConnectionFactory<JschConnectionConfig> {
    @Nullable
    private JSch jsch;

    public JschConnectionFactory() {
        this.setName("jsch");
    }

    public void setJsch(JSch jsch) {
        this.jsch = jsch;
    }

    @Override
    protected Class<?> getDefaultConnectionClass() {
        return JschConnection.class;
    }

    @Override
    protected void postConstructConnection(SshConnection connection, final JschConnectionConfig sshConfig) {
        JschConnection conn = (JschConnection)connection;
        if (this.jsch == null) {
            this.jsch = new JSch();
            this.jsch.setConfigRepository(new ConfigRepository(){

                public ConfigRepository.Config getConfig(String host) {
                    if (host.equals(sshConfig.getHost())) {
                        return sshConfig;
                    }
                    return null;
                }
            });
            JSch.setLogger((Logger)new JschLoggerToSlf4jLogger());
        }
        conn.setJsch(this.jsch);
        this.setHostKeyVerifier(conn, sshConfig);
        if (!sshConfig.hasProperty("ConnectTimeout")) {
            sshConfig.getProps().put("ConnectTimeout", "3000");
        }
    }

    @Override
    protected void setKnownHosts(final SshConnection connection, JschConnectionConfig sshConfig) {
        String filepath = sshConfig.getKnownHostsPath();
        List<File> files = SshConfigs.getKnownHostsFiles(filepath);
        if (files.isEmpty()) {
            PromiscuousHostKeyVerifier verifier = new PromiscuousHostKeyVerifier(sshConfig.getStrictHostKeyChecking() == StrictHostKeyChecking.NO);
            this.addHostKeyVerifier(connection, verifier);
            return;
        }
        Collects.forEach(files, (Consumer)new Consumer<File>(){

            public void accept(File file) {
                JschKnownHostsKeyRepository knownHostsKeyRepository = new JschKnownHostsKeyRepository(new OpenSSHKnownHosts(file));
                JSch jSch = ((JschConnection)connection).getJsch();
                jSch.setHostKeyRepository((HostKeyRepository)knownHostsKeyRepository);
            }
        });
        sshConfig.setProperty("StrictHostKeyChecking", sshConfig.getStrictHostKeyChecking().getName());
    }

    @Override
    public JschConnectionConfig newConfig() {
        return new JschConnectionConfig();
    }
}

