/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.impl.jsch;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import com.jn.agileway.ssh.client.AbstractSshConnection;
import com.jn.agileway.ssh.client.SshConnectionStatus;
import com.jn.agileway.ssh.client.SshException;
import com.jn.agileway.ssh.client.channel.SessionedChannel;
import com.jn.agileway.ssh.client.channel.forwarding.ForwardingClient;
import com.jn.agileway.ssh.client.impl.jsch.JschConnectionConfig;
import com.jn.agileway.ssh.client.impl.jsch.JschForwardingClient;
import com.jn.agileway.ssh.client.impl.jsch.JschSessionedChannel;
import com.jn.agileway.ssh.client.impl.jsch.authc.PasswordUserInfo;
import com.jn.agileway.ssh.client.impl.jsch.sftp.JschSftpSession;
import com.jn.agileway.ssh.client.sftp.SftpSession;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.MapAccessor;
import com.jn.langx.util.logging.Loggers;
import java.io.IOException;
import java.net.InetAddress;
import org.slf4j.Logger;

public class JschConnection
extends AbstractSshConnection<JschConnectionConfig> {
    private Logger logger = Loggers.getLogger(JschConnection.class);
    private JSch jsch;
    private Session delegate;

    public void setJsch(JSch jsch) {
        if (jsch != null) {
            this.jsch = jsch;
        }
    }

    public JSch getJsch() {
        return this.jsch;
    }

    @Override
    public void connect(String host, int port) throws SshException {
        ((JschConnectionConfig)this.sshConfig).setHost(host);
        ((JschConnectionConfig)this.sshConfig).setPort(port);
    }

    @Override
    public void connect(InetAddress host, int port) throws SshException {
        this.connect(host.getHostName(), port);
    }

    @Override
    public void connect(InetAddress host, int port, InetAddress localAddr, int localPort) throws SshException {
        this.connect(host, port);
    }

    private int getConnectTimeout() {
        MapAccessor mapAccessor = new MapAccessor(((JschConnectionConfig)this.sshConfig).getProps());
        int connectTimeout = mapAccessor.getInteger((Object)"ConnectTimeout", Integer.valueOf(0));
        if (connectTimeout < 0) {
            connectTimeout = 0;
        }
        return connectTimeout;
    }

    @Override
    public boolean authenticateWithPassword(String user, String password) throws SshException {
        block4: {
            if (!this.isConnected()) {
                ((JschConnectionConfig)this.sshConfig).setUser(user);
                ((JschConnectionConfig)this.sshConfig).setPassword(password);
                if (this.delegate != null) {
                    this.delegate.disconnect();
                    this.delegate = null;
                }
                try {
                    JSch.setConfig((String)"PreferredAuthentications", (String)"password,publickey,gssapi-with-mic,keyboard-interactive");
                    this.delegate = this.jsch.getSession(user, this.getHost(), this.getPort());
                    this.delegate.setPassword(password);
                    PasswordUserInfo userInfo = new PasswordUserInfo();
                    userInfo.setPassword(password);
                    this.delegate.setUserInfo((UserInfo)userInfo);
                    this.delegate.connect(this.getConnectTimeout());
                    this.setStatus(SshConnectionStatus.CONNECTED);
                    return true;
                }
                catch (Throwable ex) {
                    this.logger.error(ex.getMessage(), ex);
                    if (this.delegate == null) break block4;
                    this.delegate.disconnect();
                    this.delegate = null;
                }
            }
        }
        return true;
    }

    @Override
    public boolean authenticateWithPublicKey(String user, byte[] pemPrivateKey, String passphrase) throws SshException {
        if (!this.isConnected()) {
            ((JschConnectionConfig)this.sshConfig).setUser(user);
            if (this.delegate != null) {
                this.delegate.disconnect();
                this.delegate = null;
            }
            try {
                this.delegate = this.jsch.getSession(user, this.getHost(), this.getPort());
                if (Strings.isNotBlank((String)passphrase)) {
                    PasswordUserInfo userInfo = new PasswordUserInfo();
                    userInfo.setPassphrase(passphrase);
                    this.delegate.setUserInfo((UserInfo)userInfo);
                }
                this.delegate.connect(this.getConnectTimeout());
                this.setStatus(SshConnectionStatus.CONNECTED);
                return true;
            }
            catch (Throwable ex) {
                if (this.delegate != null) {
                    this.delegate.disconnect();
                    this.delegate = null;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public SessionedChannel openSession() throws SshException {
        Preconditions.checkState((this.getStatus() == SshConnectionStatus.CONNECTED ? 1 : 0) != 0, (String)"ssh not connected");
        Preconditions.checkNotNull((Object)(this.delegate != null && this.delegate.isConnected() ? 1 : 0));
        return new JschSessionedChannel(this.delegate);
    }

    @Override
    public ForwardingClient forwardingClient() {
        return new JschForwardingClient(this);
    }

    @Override
    protected void doClose() throws IOException {
        if (this.delegate != null) {
            this.delegate.disconnect();
        }
    }

    @Override
    public SftpSession openSftpSession() throws SshException {
        try {
            ChannelSftp channel = (ChannelSftp)this.delegate.openChannel("sftp");
            channel.connect();
            JschSftpSession session = new JschSftpSession(channel);
            session.setSshConnection(this);
            return session;
        }
        catch (JSchException ex) {
            throw new SshException(ex);
        }
    }

    Session delegate() {
        return this.delegate;
    }
}

