/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.impl.ganymedssh2.verifier;

import ch.ethz.ssh2.crypto.Base64;
import ch.ethz.ssh2.crypto.digest.Digest;
import ch.ethz.ssh2.crypto.digest.HMAC;
import ch.ethz.ssh2.crypto.digest.MD5;
import ch.ethz.ssh2.crypto.digest.SHA1;
import ch.ethz.ssh2.signature.DSAPublicKey;
import ch.ethz.ssh2.signature.DSASHA1Verify;
import ch.ethz.ssh2.signature.RSAPublicKey;
import ch.ethz.ssh2.signature.RSASHA1Verify;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Objs;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Consumer;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class KnownHosts {
    public static final int HOSTKEY_IS_OK = 0;
    public static final int HOSTKEY_IS_NEW = 1;
    public static final int HOSTKEY_HAS_CHANGED = 2;
    private LinkedList publicKeys = new LinkedList();

    public KnownHosts() {
    }

    public KnownHosts(char[] knownHostsData) throws IOException {
        this.initialize(knownHostsData);
    }

    public KnownHosts(File knownHosts) throws IOException {
        this.initialize(knownHosts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHostkey(String[] hostnames, String serverHostKeyAlgorithm, byte[] serverHostKey) throws IOException {
        if (hostnames == null) {
            throw new IllegalArgumentException("hostnames may not be null");
        }
        if ("ssh-rsa".equals(serverHostKeyAlgorithm)) {
            RSAPublicKey rpk = RSASHA1Verify.decodeSSHRSAPublicKey((byte[])serverHostKey);
            LinkedList linkedList = this.publicKeys;
            synchronized (linkedList) {
                this.publicKeys.add(new KnownHostsEntry(hostnames, rpk));
            }
        } else if ("ssh-dss".equals(serverHostKeyAlgorithm)) {
            DSAPublicKey dpk = DSASHA1Verify.decodeSSHDSAPublicKey((byte[])serverHostKey);
            LinkedList linkedList = this.publicKeys;
            synchronized (linkedList) {
                this.publicKeys.add(new KnownHostsEntry(hostnames, dpk));
            }
        } else {
            throw new IOException("Unknown host key type (" + serverHostKeyAlgorithm + ")");
        }
    }

    public void removeHostKeys(String[] hosts, final String keyType) {
        Collects.forEach((Object[])hosts, (Consumer)new Consumer<String>(){

            public void accept(String host) {
                Iterator iter = KnownHosts.this.publicKeys.iterator();
                while (iter.hasNext()) {
                    String currentKeyType;
                    Object key;
                    KnownHostsEntry entry = (KnownHostsEntry)iter.next();
                    if (!KnownHosts.this.hostnameMatches(entry.patterns, host) || !((key = entry.key) instanceof RSAPublicKey) && !(key instanceof DSAPublicKey) || !Objs.equals((Object)(currentKeyType = key instanceof RSAPublicKey ? "ssh-rsa" : "ssh-dss"), (Object)keyType)) continue;
                    String[] newPatterns = (String[])Pipeline.of((Object[])entry.patterns).remove((Object)host).toArray(String[].class);
                    if (Emptys.isEmpty((Object)newPatterns)) {
                        iter.remove();
                        continue;
                    }
                    KnownHostsEntry.access$102(entry, newPatterns);
                }
            }
        });
    }

    public void addHostkeys(char[] knownHostsData) throws IOException {
        this.initialize(knownHostsData);
    }

    public void addHostkeys(File knownHosts) throws IOException {
        this.initialize(knownHosts);
    }

    public static String createHashedHostname(String hostname) {
        SHA1 sha1 = new SHA1();
        byte[] salt = new byte[sha1.getDigestLength()];
        new SecureRandom().nextBytes(salt);
        byte[] hash = KnownHosts.hmacSha1Hash(salt, hostname);
        String base64_salt = new String(Base64.encode((byte[])salt));
        String base64_hash = new String(Base64.encode((byte[])hash));
        return "|1|" + base64_salt + "|" + base64_hash;
    }

    private static byte[] hmacSha1Hash(byte[] salt, String hostname) {
        SHA1 sha1 = new SHA1();
        if (salt.length != sha1.getDigestLength()) {
            throw new IllegalArgumentException("Salt has wrong length (" + salt.length + ")");
        }
        HMAC hmac = new HMAC((Digest)sha1, salt, salt.length);
        hmac.update(hostname.getBytes());
        byte[] dig = new byte[hmac.getDigestLength()];
        hmac.digest(dig);
        return dig;
    }

    private final boolean checkHashed(String entry, String hostname) {
        if (!entry.startsWith("|1|")) {
            return false;
        }
        int delim_idx = entry.indexOf(124, 3);
        if (delim_idx == -1) {
            return false;
        }
        String salt_base64 = entry.substring(3, delim_idx);
        String hash_base64 = entry.substring(delim_idx + 1);
        byte[] salt = null;
        byte[] hash = null;
        try {
            salt = Base64.decode((char[])salt_base64.toCharArray());
            hash = Base64.decode((char[])hash_base64.toCharArray());
        }
        catch (IOException e) {
            return false;
        }
        SHA1 sha1 = new SHA1();
        if (salt.length != sha1.getDigestLength()) {
            return false;
        }
        byte[] dig = KnownHosts.hmacSha1Hash(salt, hostname);
        for (int i = 0; i < dig.length; ++i) {
            if (dig[i] == hash[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkKey(String remoteHostname, Object remoteKey) {
        int result = 1;
        LinkedList linkedList = this.publicKeys;
        synchronized (linkedList) {
            for (KnownHostsEntry ke : this.publicKeys) {
                if (!this.hostnameMatches(ke.patterns, remoteHostname)) continue;
                boolean res = this.matchKeys(ke.key, remoteKey);
                if (res) {
                    return 0;
                }
                result = 2;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getAllKeys(String hostname) {
        Vector<Object> keys = new Vector<Object>();
        LinkedList linkedList = this.publicKeys;
        synchronized (linkedList) {
            for (KnownHostsEntry ke : this.publicKeys) {
                if (!this.hostnameMatches(ke.patterns, hostname)) continue;
                keys.addElement(ke.key);
            }
        }
        return keys;
    }

    public String[] getPreferredServerHostkeyAlgorithmOrder(String hostname) {
        String[] algos = this.recommendHostkeyAlgorithms(hostname);
        if (algos != null) {
            return algos;
        }
        InetAddress[] ipAdresses = null;
        try {
            ipAdresses = InetAddress.getAllByName(hostname);
        }
        catch (UnknownHostException e) {
            return null;
        }
        for (int i = 0; i < ipAdresses.length; ++i) {
            algos = this.recommendHostkeyAlgorithms(ipAdresses[i].getHostAddress());
            if (algos == null) continue;
            return algos;
        }
        return null;
    }

    private final boolean hostnameMatches(String[] hostpatterns, String hostname) {
        boolean isMatch = false;
        boolean negate = false;
        hostname = hostname.toLowerCase();
        for (int k = 0; k < hostpatterns.length; ++k) {
            if (hostpatterns[k] == null) continue;
            String pattern = null;
            if (hostpatterns[k].length() > 0 && hostpatterns[k].charAt(0) == '!') {
                pattern = hostpatterns[k].substring(1);
                negate = true;
            } else {
                pattern = hostpatterns[k];
                negate = false;
            }
            if (isMatch && !negate) continue;
            if (pattern.charAt(0) == '|') {
                if (!this.checkHashed(pattern, hostname)) continue;
                if (negate) {
                    return false;
                }
                isMatch = true;
                continue;
            }
            if ((pattern = pattern.toLowerCase()).indexOf(63) != -1 || pattern.indexOf(42) != -1) {
                if (!this.pseudoRegex(pattern.toCharArray(), 0, hostname.toCharArray(), 0)) continue;
                if (negate) {
                    return false;
                }
                isMatch = true;
                continue;
            }
            if (pattern.compareTo(hostname) != 0) continue;
            if (negate) {
                return false;
            }
            isMatch = true;
        }
        return isMatch;
    }

    private void initialize(char[] knownHostsData) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new CharArrayReader(knownHostsData));
        while ((line = br.readLine()) != null) {
            String[] arr;
            if ((line = line.trim()).startsWith("#") || (arr = line.split(" ")).length < 3 || arr[1].compareTo("ssh-rsa") != 0 && arr[1].compareTo("ssh-dss") != 0) continue;
            String[] hostnames = arr[0].split(",");
            byte[] msg = Base64.decode((char[])arr[2].toCharArray());
            this.addHostkey(hostnames, arr[1], msg);
        }
    }

    private void initialize(File knownHosts) throws IOException {
        int len;
        char[] buff = new char[512];
        CharArrayWriter cw = new CharArrayWriter();
        knownHosts.createNewFile();
        FileReader fr = new FileReader(knownHosts);
        while ((len = fr.read(buff)) >= 0) {
            cw.write(buff, 0, len);
        }
        fr.close();
        this.initialize(cw.toCharArray());
    }

    private final boolean matchKeys(Object key1, Object key2) {
        if (key1 instanceof RSAPublicKey && key2 instanceof RSAPublicKey) {
            RSAPublicKey savedRSAKey = (RSAPublicKey)key1;
            RSAPublicKey remoteRSAKey = (RSAPublicKey)key2;
            if (!savedRSAKey.getE().equals(remoteRSAKey.getE())) {
                return false;
            }
            return savedRSAKey.getN().equals(remoteRSAKey.getN());
        }
        if (key1 instanceof DSAPublicKey && key2 instanceof DSAPublicKey) {
            DSAPublicKey savedDSAKey = (DSAPublicKey)key1;
            DSAPublicKey remoteDSAKey = (DSAPublicKey)key2;
            if (!savedDSAKey.getG().equals(remoteDSAKey.getG())) {
                return false;
            }
            if (!savedDSAKey.getP().equals(remoteDSAKey.getP())) {
                return false;
            }
            if (!savedDSAKey.getQ().equals(remoteDSAKey.getQ())) {
                return false;
            }
            return savedDSAKey.getY().equals(remoteDSAKey.getY());
        }
        return false;
    }

    private final boolean pseudoRegex(char[] pattern, int i, char[] match, int j) {
        while (pattern.length != i) {
            if (pattern[i] == '*') {
                if (pattern.length == ++i) {
                    return true;
                }
                if (pattern[i] != '*' && pattern[i] != '?') {
                    do {
                        if (pattern[i] != match[j] || !this.pseudoRegex(pattern, i + 1, match, j + 1)) continue;
                        return true;
                    } while (match.length != ++j);
                    return false;
                }
                do {
                    if (!this.pseudoRegex(pattern, i, match, j)) continue;
                    return true;
                } while (match.length != ++j);
                return false;
            }
            if (match.length == j) {
                return false;
            }
            if (pattern[i] != '?' && pattern[i] != match[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return match.length == j;
    }

    private String[] recommendHostkeyAlgorithms(String hostname) {
        String preferredAlgo = null;
        Vector keys = this.getAllKeys(hostname);
        for (int i = 0; i < keys.size(); ++i) {
            String thisAlgo = null;
            if (keys.elementAt(i) instanceof RSAPublicKey) {
                thisAlgo = "ssh-rsa";
            } else {
                if (!(keys.elementAt(i) instanceof DSAPublicKey)) continue;
                thisAlgo = "ssh-dss";
            }
            if (preferredAlgo == null || preferredAlgo.compareTo(thisAlgo) == 0) continue;
            return null;
        }
        if (preferredAlgo == null) {
            return null;
        }
        if (preferredAlgo.equals("ssh-rsa")) {
            return new String[]{"ssh-rsa", "ssh-dss"};
        }
        return new String[]{"ssh-dss", "ssh-rsa"};
    }

    public int verifyHostkey(String hostname, String serverHostKeyAlgorithm, byte[] serverHostKey) throws IOException {
        RSAPublicKey remoteKey = null;
        if ("ssh-rsa".equals(serverHostKeyAlgorithm)) {
            remoteKey = RSASHA1Verify.decodeSSHRSAPublicKey((byte[])serverHostKey);
        } else if ("ssh-dss".equals(serverHostKeyAlgorithm)) {
            remoteKey = DSASHA1Verify.decodeSSHDSAPublicKey((byte[])serverHostKey);
        } else {
            throw new IllegalArgumentException("Unknown hostkey type " + serverHostKeyAlgorithm);
        }
        int result = this.checkKey(hostname, remoteKey);
        if (result == 0) {
            return result;
        }
        InetAddress[] ipAdresses = null;
        try {
            ipAdresses = InetAddress.getAllByName(hostname);
        }
        catch (UnknownHostException e) {
            return result;
        }
        for (int i = 0; i < ipAdresses.length; ++i) {
            int newresult = this.checkKey(ipAdresses[i].getHostAddress(), remoteKey);
            if (newresult == 0) {
                return newresult;
            }
            if (newresult != 2) continue;
            result = 2;
        }
        return result;
    }

    public static final void addHostkeyToFile(File knownHosts, String[] hostnames, String serverHostKeyAlgorithm, byte[] serverHostKey) throws IOException {
        if (hostnames == null || hostnames.length == 0) {
            throw new IllegalArgumentException("Need at least one hostname specification");
        }
        if (serverHostKeyAlgorithm == null || serverHostKey == null) {
            throw new IllegalArgumentException();
        }
        CharArrayWriter writer = new CharArrayWriter();
        for (int i = 0; i < hostnames.length; ++i) {
            if (i != 0) {
                writer.write(44);
            }
            writer.write(hostnames[i]);
        }
        writer.write(32);
        writer.write(serverHostKeyAlgorithm);
        writer.write(32);
        writer.write(Base64.encode((byte[])serverHostKey));
        writer.write("\n");
        char[] entry = writer.toCharArray();
        RandomAccessFile raf = new RandomAccessFile(knownHosts, "rw");
        long len = raf.length();
        if (len > 0L) {
            raf.seek(len - 1L);
            int last = raf.read();
            if (last != 10) {
                raf.write(10);
            }
        }
        raf.write(new String(entry).getBytes());
        raf.close();
    }

    private static final byte[] rawFingerPrint(String type, String keyType, byte[] hostkey) {
        MD5 dig = null;
        if ("md5".equals(type)) {
            dig = new MD5();
        } else if ("sha1".equals(type)) {
            dig = new SHA1();
        } else {
            throw new IllegalArgumentException("Unknown hash type " + type);
        }
        if (!"ssh-rsa".equals(keyType) && !"ssh-dss".equals(keyType)) {
            throw new IllegalArgumentException("Unknown key type " + keyType);
        }
        if (hostkey == null) {
            throw new IllegalArgumentException("hostkey is null");
        }
        dig.update(hostkey);
        byte[] res = new byte[dig.getDigestLength()];
        dig.digest(res);
        return res;
    }

    private static final String rawToHexFingerprint(byte[] fingerprint) {
        char[] alpha = "0123456789abcdef".toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fingerprint.length; ++i) {
            if (i != 0) {
                sb.append(':');
            }
            int b = fingerprint[i] & 0xFF;
            sb.append(alpha[b >> 4]);
            sb.append(alpha[b & 0xF]);
        }
        return sb.toString();
    }

    private static final String rawToBubblebabbleFingerprint(byte[] raw) {
        char[] v = "aeiouy".toCharArray();
        char[] c = "bcdfghklmnprstvzx".toCharArray();
        StringBuilder sb = new StringBuilder();
        int seed = 1;
        int rounds = raw.length / 2 + 1;
        sb.append('x');
        for (int i = 0; i < rounds; ++i) {
            if (i + 1 < rounds || raw.length % 2 != 0) {
                sb.append(v[((raw[2 * i] >> 6 & 3) + seed) % 6]);
                sb.append(c[raw[2 * i] >> 2 & 0xF]);
                sb.append(v[((raw[2 * i] & 3) + seed / 6) % 6]);
                if (i + 1 >= rounds) continue;
                sb.append(c[raw[2 * i + 1] >> 4 & 0xF]);
                sb.append('-');
                sb.append(c[raw[2 * i + 1] & 0xF]);
                seed = (seed * 5 + ((raw[2 * i] & 0xFF) * 7 + (raw[2 * i + 1] & 0xFF))) % 36;
                continue;
            }
            sb.append(v[seed % 6]);
            sb.append('x');
            sb.append(v[seed / 6]);
        }
        sb.append('x');
        return sb.toString();
    }

    public static final String createHexFingerprint(String keytype, byte[] publickey) {
        byte[] raw = KnownHosts.rawFingerPrint("md5", keytype, publickey);
        return KnownHosts.rawToHexFingerprint(raw);
    }

    public static final String createBubblebabbleFingerprint(String keytype, byte[] publickey) {
        byte[] raw = KnownHosts.rawFingerPrint("sha1", keytype, publickey);
        return KnownHosts.rawToBubblebabbleFingerprint(raw);
    }

    class KnownHostsEntry {
        private String[] patterns;
        Object key;

        KnownHostsEntry(String[] patterns, Object key) {
            this.patterns = patterns;
            this.key = key;
        }

        static /* synthetic */ String[] access$102(KnownHostsEntry x0, String[] x1) {
            x0.patterns = x1;
            return x1;
        }
    }
}

