/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.impl.ganymedssh2;

import ch.ethz.ssh2.Session;
import com.jn.agileway.ssh.client.SshException;
import com.jn.agileway.ssh.client.channel.AbstarctSessionedChannel;
import com.jn.agileway.ssh.client.utils.PTYMode;
import com.jn.agileway.ssh.client.utils.Signal;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.io.Charsets;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

class Ssh2SessionedChannel
extends AbstarctSessionedChannel {
    private Session session;

    Ssh2SessionedChannel(@NonNull Session session) {
        Preconditions.checkNotNull((Object)session);
        this.session = session;
    }

    @Override
    public void pty(String term) throws SshException {
        this.pty(term, 0, 0, 0, 0, null);
    }

    @Override
    public void pty(String term, int termWidthCharacters, int termHeightCharacters, int termWidthPixels, int termHeightPixels, Map<PTYMode, Integer> terminalModes) throws SshException {
        byte[] terminalModesBytes = null;
        if (Emptys.isNotEmpty(terminalModes)) {
            terminalModesBytes = PTYMode.encode(terminalModes);
        }
        try {
            this.session.requestPTY(term, termWidthCharacters, termHeightCharacters, termWidthPixels, termHeightPixels, terminalModesBytes);
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
    }

    @Override
    protected void internalX11Forwarding(String host, int port, boolean singleConnection, String x11AuthenticationProtocol, String x11AuthenticationCookie, int x11ScreenNumber) throws SshException {
        try {
            this.session.requestX11Forwarding(host, port, Strings.isBlank((String)x11AuthenticationCookie) ? null : x11AuthenticationCookie.getBytes(Charsets.UTF_8), singleConnection);
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
    }

    @Override
    public void env(String variableName, String variableValue) throws SshException {
    }

    @Override
    protected void internalExec(String command) throws SshException {
        Preconditions.checkNotEmpty((Object)command, (String)"the command is illegal : {}", (Object[])new Object[]{command});
        try {
            this.session.execCommand(command);
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
    }

    @Override
    protected void internalSubsystem(String subsystem) throws SshException {
        Preconditions.checkNotEmpty((Object)subsystem, (String)"the subsystem is illegal : {}", (Object[])new Object[]{subsystem});
        try {
            this.session.startSubSystem(subsystem);
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
    }

    @Override
    protected void internalShell() throws SshException {
        try {
            this.session.startShell();
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
    }

    @Override
    public void signal(Signal signal) throws SshException {
    }

    @Override
    public int getExitStatus() {
        Integer exitStatus = this.session.getExitStatus();
        if (exitStatus == null) {
            this.session.waitForCondition(32, 60000L);
            exitStatus = this.session.getExitStatus();
        }
        return exitStatus;
    }

    @Override
    public void close() {
        this.session.close();
    }

    @Override
    public InputStream getInputStream() throws SshException {
        try {
            return this.session.getStdout();
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
    }

    @Override
    public OutputStream getOutputStream() throws SshException {
        try {
            return this.session.getStdin();
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
    }

    @Override
    public InputStream getErrorInputStream() throws SshException {
        try {
            return this.session.getStderr();
        }
        catch (Throwable ex) {
            throw new SshException(ex);
        }
    }
}

