/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client;

import com.jn.agileway.ssh.client.SshConnectionFactory;
import com.jn.langx.lifecycle.InitializationException;
import com.jn.langx.registry.GenericRegistry;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.reflect.annotation.OnClassesConditions;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;

public class SshConnectionFactoryRegistry
extends GenericRegistry<SshConnectionFactory> {
    private static final Logger logger = Loggers.getLogger(SshConnectionFactoryRegistry.class);
    private static final Map<String, SshConnectionFactory> preinstall = new LinkedHashMap<String, SshConnectionFactory>();

    public SshConnectionFactoryRegistry() {
        this.init();
    }

    private static boolean checkSshConnectionFactory(SshConnectionFactory factory) {
        return OnClassesConditions.allPresent(factory.getClass(), (boolean)true);
    }

    public void register(String key, SshConnectionFactory sshConnectionFactory) {
        if (sshConnectionFactory != null) {
            this.registry.put(key, sshConnectionFactory);
        }
    }

    protected void doInit() throws InitializationException {
        this.registry.putAll(preinstall);
    }

    public SshConnectionFactory getDefault() {
        Preconditions.checkNotEmpty((Object)this.registry);
        String first = (String)Pipeline.of((Iterable)Collects.asIterable((Object)this.names())).findFirst();
        return (SshConnectionFactory)this.get(first);
    }

    static {
        Iterator<SshConnectionFactory> iterator = ServiceLoader.load(SshConnectionFactory.class).iterator();
        while (iterator.hasNext()) {
            try {
                SshConnectionFactory sshConnectionFactory = iterator.next();
                if (!OnClassesConditions.allPresent(sshConnectionFactory.getClass(), (boolean)true)) continue;
                preinstall.put(sshConnectionFactory.getName(), sshConnectionFactory);
            }
            catch (Throwable ex) {
                logger.error(ex.getMessage());
            }
        }
        if (preinstall.isEmpty()) {
            logger.warn("Can't find any valid ssh-client library, the recommend ssh client libraries: net.schmizz:sshj, com.trilead:trilead-ssh2, com.airlenet.yang:ganymed-ssh2, com.jcraft:jsch");
        }
    }
}

