/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client;

import com.jn.agileway.ssh.client.SshConnection;
import com.jn.agileway.ssh.client.SshConnectionConfig;
import com.jn.agileway.ssh.client.SshConnectionFactory;
import com.jn.agileway.ssh.client.SshException;
import com.jn.agileway.ssh.client.transport.hostkey.StrictHostKeyChecking;
import com.jn.agileway.ssh.client.transport.hostkey.knownhosts.OpenSSHKnownHosts;
import com.jn.agileway.ssh.client.transport.hostkey.verifier.HostKeyVerifier;
import com.jn.agileway.ssh.client.transport.hostkey.verifier.KnownHostsVerifier;
import com.jn.agileway.ssh.client.transport.hostkey.verifier.PromiscuousHostKeyVerifier;
import com.jn.agileway.ssh.client.utils.SshConfigs;
import com.jn.langx.AbstractNameable;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.net.Nets;
import com.jn.langx.util.reflect.Reflects;
import java.io.File;
import java.net.InetAddress;
import java.util.List;
import org.slf4j.Logger;

public abstract class AbstractSshConnectionFactory<CONF extends SshConnectionConfig>
extends AbstractNameable
implements SshConnectionFactory<CONF> {
    protected Logger logger = Loggers.getLogger(this.getClass());

    @Override
    public SshConnection get(CONF sshConfig) {
        return this.connectAndAuthenticate(sshConfig);
    }

    protected SshConnection createConnection(CONF sshConfig) {
        SshConnection connection = null;
        Class<?> connectionClass = this.getDefaultConnectionClass();
        Preconditions.checkNotNull(connectionClass);
        connection = (SshConnection)Reflects.newInstance(connectionClass);
        connection.setConfig(sshConfig);
        this.postConstructConnection(connection, sshConfig);
        return connection;
    }

    protected void postConstructConnection(@NonNull SshConnection connection, @NonNull CONF sshConfig) {
        this.setHostKeyVerifier(connection, sshConfig);
    }

    protected abstract Class<?> getDefaultConnectionClass();

    protected void setHostKeyVerifier(@NonNull SshConnection connection, @NonNull CONF sshConfig) {
        HostKeyVerifier hostKeyVerifier = sshConfig.getHostKeyVerifier();
        if (hostKeyVerifier != null) {
            connection.addHostKeyVerifier(hostKeyVerifier);
            return;
        }
        StrictHostKeyChecking strictHostKeyChecking = sshConfig.getStrictHostKeyChecking();
        if (strictHostKeyChecking != StrictHostKeyChecking.NO) {
            sshConfig.setStrictHostKeyChecking(StrictHostKeyChecking.YES);
        }
        this.setKnownHosts(connection, sshConfig);
    }

    protected void setKnownHosts(final @NonNull SshConnection connection, final @NonNull CONF sshConfig) {
        String filepath = sshConfig.getKnownHostsPath();
        List<File> files = SshConfigs.getKnownHostsFiles(filepath);
        if (files.isEmpty()) {
            PromiscuousHostKeyVerifier verifier = new PromiscuousHostKeyVerifier(sshConfig.getStrictHostKeyChecking() == StrictHostKeyChecking.NO);
            this.addHostKeyVerifier(connection, verifier);
            return;
        }
        Collects.forEach(files, (Consumer)new Consumer<File>(){

            public void accept(File file) {
                OpenSSHKnownHosts repository = new OpenSSHKnownHosts(file);
                KnownHostsVerifier verifier = new KnownHostsVerifier(repository, sshConfig.getStrictHostKeyChecking());
                AbstractSshConnectionFactory.this.addHostKeyVerifier(connection, verifier);
            }
        });
    }

    protected void addHostKeyVerifier(SshConnection connection, HostKeyVerifier verifier) {
        connection.addHostKeyVerifier(verifier);
    }

    protected SshConnection connectAndAuthenticate(CONF sshConfig) {
        SshConnection connection = this.createConnection(sshConfig);
        String host = sshConfig.getHost();
        int port = sshConfig.getPort();
        InetAddress remoteAddress = null;
        try {
            remoteAddress = InetAddress.getByName(host);
        }
        catch (Throwable ex) {
            this.logger.error("invalid host: {}", (Object)host);
            return null;
        }
        if (!Nets.isValidPort((int)port)) {
            this.logger.error("invalid port: {}", (Object)port);
            return null;
        }
        String localHost = sshConfig.getLocalHost();
        int localPort = sshConfig.getLocalPort();
        InetAddress localAddress = null;
        if (Emptys.isNotEmpty((Object)localHost)) {
            try {
                localAddress = InetAddress.getByName(localHost);
            }
            catch (Throwable ex) {
                this.logger.warn(ex.getMessage(), ex);
            }
        }
        try {
            if (localAddress != null && Nets.isValidPort((int)localPort)) {
                connection.connect(remoteAddress, port, localAddress, localPort);
            } else {
                connection.connect(host, port);
            }
        }
        catch (Throwable ex) {
            this.logger.error(ex.getMessage(), ex);
            IOs.close((Object)connection);
            connection = null;
            return null;
        }
        if (this.authenticate(connection, (SshConnectionConfig)sshConfig)) {
            return connection;
        }
        return null;
    }

    protected boolean authenticate(SshConnection connection, SshConnectionConfig sshConfig) {
        String privateKeyfilePath;
        String user = sshConfig.getUser();
        if (Strings.isBlank((String)user)) {
            return false;
        }
        String password = sshConfig.getPassword();
        boolean authcSuccess = false;
        if (Strings.isNotBlank((String)password)) {
            try {
                authcSuccess = connection.authenticateWithPassword(user, password);
            }
            catch (SshException ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
                return false;
            }
        }
        if (!authcSuccess && Strings.isNotBlank((String)(privateKeyfilePath = sshConfig.getPrivateKeyfilePath()))) {
            String passphrase = sshConfig.getPrivateKeyfilePassphrase();
            File privateKeyfile = new File(privateKeyfilePath);
            if (privateKeyfile.exists()) {
                try {
                    authcSuccess = connection.authenticateWithPublicKey(user, privateKeyfile, passphrase);
                }
                catch (SshException ex) {
                    this.logger.error(ex.getMessage(), (Throwable)ex);
                    return false;
                }
            }
        }
        return authcSuccess;
    }
}

