/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client;

import com.jn.agileway.ssh.client.SshClients;
import com.jn.agileway.ssh.client.SshConnection;
import com.jn.agileway.ssh.client.SshConnectionConfig;
import com.jn.agileway.ssh.client.SshConnectionStatus;
import com.jn.agileway.ssh.client.SshException;
import com.jn.agileway.ssh.client.transport.hostkey.verifier.AnyHostKeyVerifier;
import com.jn.agileway.ssh.client.transport.hostkey.verifier.HostKeyVerifier;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.PrimitiveArrays;
import com.jn.langx.util.io.Charsets;
import com.jn.langx.util.io.IOs;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public abstract class AbstractSshConnection<CONF extends SshConnectionConfig>
implements SshConnection<CONF> {
    private String connId;
    protected CONF sshConfig;
    private SshConnectionStatus status = SshConnectionStatus.INITIALING;
    protected AnyHostKeyVerifier hostKeyVerifier = new AnyHostKeyVerifier();
    private int uid = -1;
    private int[] groupIds;

    @Override
    public String getId() {
        return this.connId;
    }

    @Override
    public void setId(String id) {
        this.connId = id;
    }

    @Override
    public String getHost() {
        return this.getConfig().getHost();
    }

    @Override
    public void setConfig(CONF connConfig) {
        this.sshConfig = connConfig;
    }

    @Override
    public CONF getConfig() {
        return this.sshConfig;
    }

    @Override
    public int getPort() {
        return this.getConfig().getPort();
    }

    @Override
    public void addHostKeyVerifier(HostKeyVerifier hostKeyVerifier) {
        this.hostKeyVerifier.add(hostKeyVerifier);
    }

    @Override
    public boolean authenticateWithPublicKey(String user, File pemFile, String passphrase) throws SshException {
        if (pemFile == null) {
            throw new IllegalArgumentException("pemFile argument is null");
        }
        char[] buff = new char[256];
        CharArrayWriter cw = new CharArrayWriter();
        FileReader fr = null;
        try {
            fr = new FileReader(pemFile);
            int len = 0;
            while ((len = fr.read(buff)) != -1) {
                cw.write(buff, 0, len);
            }
        }
        catch (IOException ex) {
            try {
                throw new SshException(ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                IOs.close(fr);
                throw throwable;
            }
        }
        IOs.close((Object)fr);
        return this.authenticateWithPublicKey(user, new String(cw.toCharArray()).getBytes(Charsets.UTF_8), passphrase);
    }

    @Override
    public final boolean isClosed() {
        return this.status == SshConnectionStatus.CLOSED;
    }

    @Override
    public final boolean isConnected() {
        return this.status.getCode() >= SshConnectionStatus.CONNECTED.getCode();
    }

    @Override
    public SshConnectionStatus getStatus() {
        return this.status;
    }

    protected void setStatus(SshConnectionStatus status) {
        Preconditions.checkNotNull((Object)((Object)status));
        this.status = status;
    }

    @Override
    public final void close() throws IOException {
        this.hostKeyVerifier.clear();
        this.setStatus(SshConnectionStatus.CLOSED);
        this.doClose();
    }

    protected abstract void doClose() throws IOException;

    @Override
    public int getUid() {
        if (this.uid < 0 || this.groupIds == null) {
            this.refreshUidGroupIds();
        }
        return this.uid;
    }

    @Override
    public int[] getGroupIds() {
        if (this.uid < 0 || this.groupIds == null) {
            this.refreshUidGroupIds();
        }
        return PrimitiveArrays.copy((int[])this.groupIds);
    }

    @Override
    public final void refreshUidGroupIds() {
        this.uid = SshClients.getUid(this);
        this.groupIds = SshClients.getGroupIds(this);
    }
}

