/*
 * Decompiled with CFR 0.152.
 */
package com.berkleytechnologyservices.restdocs.mojo;

import com.epages.restdocs.apispec.model.ResourceModel;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.plugin.MojoExecutionException;

@Named
public class SnippetReader {
    private static final String SNIPPET_FILENAME = "resource.json";
    private final ObjectMapper objectMapper;

    @Inject
    public SnippetReader() {
        this(new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).registerModule((Module)new KotlinModule()));
    }

    public SnippetReader(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public List<ResourceModel> getModels(File snippetsDirectory) throws MojoExecutionException {
        try {
            return Files.walk(snippetsDirectory.toPath(), FileVisitOption.FOLLOW_LINKS).filter(this::isResourceFile).map(this::getModel).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read snippets from " + String.valueOf(snippetsDirectory), (Exception)e);
        }
    }

    private ResourceModel getModel(Path path) {
        try {
            return (ResourceModel)this.objectMapper.readValue(path.toFile(), ResourceModel.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to parse snippet file: " + String.valueOf(path), e);
        }
    }

    private boolean isResourceFile(Path path) {
        return path.toFile().getName().equals(SNIPPET_FILENAME);
    }
}

