/*
 * Decompiled with CFR 0.152.
 */
package com.berkleytechnologyservices.restdocs.mojo;

import com.berkleytechnologyservices.restdocs.mojo.AbstractGenerateMojo;
import com.berkleytechnologyservices.restdocs.mojo.SnippetReader;
import com.berkleytechnologyservices.restdocs.spec.generator.SpecificationGeneratorFactory;
import com.epages.restdocs.apispec.model.ResourceModel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Named
@Mojo(name="aggregate", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, aggregator=true, threadSafe=true)
public class AggregateMojo
extends AbstractGenerateMojo {
    @Parameter
    private List<String> snippetDirectories;
    @Parameter(property="reactorProjects", readonly=true)
    private List<MavenProject> reactorProjects;
    private final SnippetReader snippetReader;

    @Inject
    public AggregateMojo(SpecificationGeneratorFactory specificationGeneratorFactory, SnippetReader snippetReader) {
        super(specificationGeneratorFactory);
        this.snippetReader = snippetReader;
    }

    @Override
    protected List<ResourceModel> getModels() throws MojoExecutionException {
        ArrayList<ResourceModel> snippets = new ArrayList<ResourceModel>();
        for (MavenProject childProject : this.reactorProjects) {
            List<File> childSnippetDirectories = this.snippetDirectories == null ? this.getDefaultSnippetDirectories(childProject) : this.snippetDirectories.stream().map(path -> new File(childProject.getBasedir(), (String)path)).filter(snippetsDirectory -> snippetsDirectory.exists() && snippetsDirectory.canRead()).collect(Collectors.toList());
            for (File snippetsDirectory2 : childSnippetDirectories) {
                snippets.addAll(this.snippetReader.getModels(snippetsDirectory2));
            }
        }
        return snippets;
    }

    private List<File> getDefaultSnippetDirectories(MavenProject project) {
        File defaultSnippetDirectory = new File(project.getBuild().getDirectory(), "generated-snippets");
        return AggregateMojo.isValidDirectory(defaultSnippetDirectory) ? Collections.singletonList(defaultSnippetDirectory) : Collections.emptyList();
    }

    private static boolean isValidDirectory(File directory) {
        return directory.exists() && directory.canRead();
    }
}

