/*
 * Decompiled with CFR 0.152.
 */
package com.berkleytechnologyservices.restdocs.mojo;

import com.berkleytechnologyservices.restdocs.mojo.SpecificationOptions;
import com.berkleytechnologyservices.restdocs.spec.ApiDetails;
import com.berkleytechnologyservices.restdocs.spec.AuthConfig;
import com.berkleytechnologyservices.restdocs.spec.Contact;
import com.berkleytechnologyservices.restdocs.spec.Specification;
import com.berkleytechnologyservices.restdocs.spec.SpecificationFormat;
import com.berkleytechnologyservices.restdocs.spec.Tag;
import com.berkleytechnologyservices.restdocs.spec.generator.SpecificationGeneratorException;
import com.berkleytechnologyservices.restdocs.spec.generator.SpecificationGeneratorFactory;
import com.epages.restdocs.apispec.model.ResourceModel;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractGenerateMojo
extends AbstractMojo {
    private static final String FORMAT_UNSUPPORTED = "%s does not support '%s' format. Supported formats include the following: %s";
    @Parameter(defaultValue="${project.artifactId}", required=true)
    private String name;
    @Parameter(defaultValue="${project.version}", required=true)
    private String version;
    @Parameter(defaultValue="${project.description}", required=true)
    private String description;
    @Parameter
    private Set<String> hosts;
    @Parameter(defaultValue="localhost")
    private String host;
    @Parameter
    private String basePath;
    @Parameter
    private List<String> schemes = Collections.emptyList();
    @Parameter(defaultValue="${project.build.directory}/restdocs-spec", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="false", property="skipSpecGenerator")
    private boolean skip;
    @Parameter(defaultValue="OPENAPI_V2", property="specification", required=true)
    private Specification specification = Specification.OPENAPI_V2;
    @Parameter(property="format")
    private SpecificationFormat format;
    @Parameter(property="filename")
    private String filename;
    @Parameter(defaultValue="false", property="separatePublicApi", required=true)
    private boolean separatePublicApi;
    @Parameter
    private List<SpecificationOptions> specifications = Collections.emptyList();
    @Parameter
    private AuthConfig oauth2 = new AuthConfig();
    @Parameter
    private List<Tag> tags;
    @Parameter
    private Contact contact;
    private final SpecificationGeneratorFactory specificationGeneratorFactory;

    @Inject
    public AbstractGenerateMojo(SpecificationGeneratorFactory specificationGeneratorFactory) {
        this.specificationGeneratorFactory = specificationGeneratorFactory;
    }

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping generation of API specification document.");
        } else {
            this.validateOutputDirectory();
            List<SpecificationOptions> allSpecificationOptions = this.getAllSpecificationOptions();
            this.validateOptions(allSpecificationOptions);
            this.generateSpecifications(allSpecificationOptions);
        }
    }

    private void validateOutputDirectory() throws MojoExecutionException {
        if (this.outputDirectory.mkdirs()) {
            this.getLog().info((CharSequence)("Creating output directory: " + String.valueOf(this.outputDirectory)));
        }
        if (!this.outputDirectory.exists() || !this.outputDirectory.canWrite()) {
            throw new MojoExecutionException("Unable to create output directory: " + String.valueOf(this.outputDirectory));
        }
    }

    private void validateOptions(List<SpecificationOptions> allSpecificationOptions) throws MojoExecutionException {
        for (SpecificationOptions options : allSpecificationOptions) {
            this.validateOptions(options);
        }
    }

    private void validateOptions(SpecificationOptions options) throws MojoExecutionException {
        if (!options.getType().supportsFormat(options.getFormat())) {
            throw new MojoExecutionException(String.format(FORMAT_UNSUPPORTED, options.getType(), options.getFormat(), options.getType().getSupportedFormats()));
        }
    }

    protected abstract List<ResourceModel> getModels() throws MojoExecutionException;

    private void generateSpecifications(List<SpecificationOptions> allSpecificationOptions) throws MojoExecutionException {
        List<ResourceModel> snippets = this.getModels();
        for (SpecificationOptions options : allSpecificationOptions) {
            this.writeSpecificationToFile(options.getFilenameWithExtension(), this.generateSpecification(options, snippets));
            if (!this.separatePublicApi) continue;
            List<ResourceModel> publicResources = snippets.stream().filter(resource -> !resource.getPrivateResource()).collect(Collectors.toList());
            this.writeSpecificationToFile(options.getPublicFilenameWithExtension(), this.generateSpecification(options, publicResources));
        }
    }

    private String generateSpecification(SpecificationOptions options, List<ResourceModel> models) throws MojoExecutionException {
        try {
            return this.specificationGeneratorFactory.createGenerator(options.getType()).generate(this.createApiDetails(options), models);
        }
        catch (SpecificationGeneratorException e) {
            throw new MojoExecutionException("Unable to generate specification.", (Exception)((Object)e));
        }
    }

    private void writeSpecificationToFile(String filename, String outputString) throws MojoExecutionException {
        Path filePath = new File(this.outputDirectory, filename).toPath();
        try {
            Files.write(filePath, outputString.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write outputString file: " + String.valueOf(filePath));
        }
    }

    private ApiDetails createApiDetails(SpecificationOptions options) {
        return new ApiDetails().name(this.name).version(this.version).description(this.description).hosts(this.hosts == null || this.hosts.isEmpty() ? Collections.singleton(this.host) : this.hosts).basePath(this.basePath).schemes(this.schemes).format(options.getFormat()).authConfig(this.oauth2).tags(this.tags).contact(this.contact);
    }

    private List<SpecificationOptions> getAllSpecificationOptions() {
        ArrayList<SpecificationOptions> options = new ArrayList<SpecificationOptions>(this.specifications);
        if (options.isEmpty()) {
            SpecificationOptions defaultOptions = new SpecificationOptions();
            defaultOptions.setType(this.specification);
            defaultOptions.setFormat(this.format);
            defaultOptions.setFilename(this.filename);
            options.add(defaultOptions);
        }
        return options;
    }
}

