/*
 * Decompiled with CFR 0.152.
 */
package com.berkleytechnologyservices.restdocs.spec;

import com.berkleytechnologyservices.restdocs.spec.SpecificationFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum Specification {
    OPENAPI_V2("openapi-2.0", SpecificationFormat.YAML, SpecificationFormat.JSON),
    OPENAPI_V3("openapi-3.0", SpecificationFormat.YAML, SpecificationFormat.JSON),
    POSTMAN_COLLECTION("postman-collection", SpecificationFormat.JSON, new SpecificationFormat[0]);

    private final String defaultFilename;
    private final SpecificationFormat defaultFormat;
    private final Set<SpecificationFormat> formats;

    private Specification(String defaultFilename, SpecificationFormat defaultFormat, SpecificationFormat ... formats) {
        this.defaultFilename = defaultFilename;
        this.defaultFormat = defaultFormat;
        this.formats = Specification.createFormatsSet(defaultFormat, formats);
    }

    public String getDefaultFilename() {
        return this.defaultFilename;
    }

    public Set<SpecificationFormat> getSupportedFormats() {
        return this.formats;
    }

    public boolean supportsFormat(SpecificationFormat format) {
        return this.formats.contains((Object)format);
    }

    public SpecificationFormat getDefaultFormat() {
        return this.defaultFormat;
    }

    private static Set<SpecificationFormat> createFormatsSet(SpecificationFormat defaultFormat, SpecificationFormat ... formats) {
        HashSet<SpecificationFormat> formatSet = new HashSet<SpecificationFormat>();
        formatSet.add(defaultFormat);
        formatSet.addAll(Arrays.asList(formats));
        return Collections.unmodifiableSet(formatSet);
    }
}

