/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.time;

import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.randomizers.time.LocalDateRandomizer;
import io.github.benas.randombeans.randomizers.time.LocalTimeRandomizer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

public class LocalDateTimeRandomizer
implements Randomizer<LocalDateTime> {
    private LocalDateRandomizer localDateRandomizer;
    private LocalTimeRandomizer localTimeRandomizer;

    public LocalDateTimeRandomizer() {
        this.localDateRandomizer = new LocalDateRandomizer();
        this.localTimeRandomizer = new LocalTimeRandomizer();
    }

    public LocalDateTimeRandomizer(long seed) {
        this.localDateRandomizer = new LocalDateRandomizer(seed);
        this.localTimeRandomizer = new LocalTimeRandomizer(seed);
    }

    public static LocalDateTimeRandomizer aNewLocalDateTimeRandomizer() {
        return new LocalDateTimeRandomizer();
    }

    public static LocalDateTimeRandomizer aNewLocalDateTimeRandomizer(long seed) {
        return new LocalDateTimeRandomizer(seed);
    }

    @Override
    public LocalDateTime getRandomValue() {
        LocalDate localDate = this.localDateRandomizer.getRandomValue();
        LocalTime localTime = this.localTimeRandomizer.getRandomValue();
        return LocalDateTime.of(localDate, localTime);
    }

    public void setLocalDateRandomizer(LocalDateRandomizer localDateRandomizer) {
        this.localDateRandomizer = localDateRandomizer;
    }

    public void setLocalTimeRandomizer(LocalTimeRandomizer localTimeRandomizer) {
        this.localTimeRandomizer = localTimeRandomizer;
    }
}

