/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.range;

import io.github.benas.randombeans.randomizers.range.AbstractRangeRandomizer;
import io.github.benas.randombeans.util.Constants;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;

public class ZonedDateTimeRangeRandomizer
extends AbstractRangeRandomizer<ZonedDateTime> {
    public ZonedDateTimeRangeRandomizer(ZonedDateTime min, ZonedDateTime max) {
        super(min, max);
    }

    public ZonedDateTimeRangeRandomizer(ZonedDateTime min, ZonedDateTime max, long seed) {
        super(min, max, seed);
    }

    public static ZonedDateTimeRangeRandomizer aNewZonedDateTimeRangeRandomizer(ZonedDateTime min, ZonedDateTime max) {
        return new ZonedDateTimeRangeRandomizer(min, max);
    }

    public static ZonedDateTimeRangeRandomizer aNewZonedDateTimeRangeRandomizer(ZonedDateTime min, ZonedDateTime max, long seed) {
        return new ZonedDateTimeRangeRandomizer(min, max, seed);
    }

    @Override
    protected void checkValues() {
        if (((ZonedDateTime)this.min).isAfter((ChronoZonedDateTime)this.max)) {
            throw new IllegalArgumentException("max must be after min");
        }
    }

    @Override
    protected ZonedDateTime getDefaultMinValue() {
        return Constants.DEFAULT_DATES_RANGE.getMin();
    }

    @Override
    protected ZonedDateTime getDefaultMaxValue() {
        return Constants.DEFAULT_DATES_RANGE.getMax();
    }

    @Override
    public ZonedDateTime getRandomValue() {
        long minSeconds = ((ZonedDateTime)this.min).toEpochSecond();
        long maxSeconds = ((ZonedDateTime)this.max).toEpochSecond();
        long seconds = this.nextLong(minSeconds, maxSeconds);
        int minNanoSeconds = ((ZonedDateTime)this.min).getNano();
        int maxNanoSeconds = ((ZonedDateTime)this.max).getNano();
        long nanoSeconds = this.nextLong(minNanoSeconds, maxNanoSeconds);
        return ZonedDateTime.ofInstant(Instant.ofEpochSecond(seconds, nanoSeconds), ((ZonedDateTime)this.min).getZone());
    }
}

