/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.api;

import io.github.benas.randombeans.util.Constants;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Random;

public class EnhancedRandomParameters {
    private long seed = new Random().nextLong();
    private int minCollectionSize = 1;
    private int maxCollectionSize = 127;
    private int maxStringLength = 32;
    private int minStringLength = 1;
    private int maxObjectPoolSize = 10;
    private Charset charset = StandardCharsets.US_ASCII;
    private boolean scanClasspathForConcreteTypes = false;
    private boolean overrideDefaultInitialization = false;
    private Range<LocalDate> dateRange = new Range<LocalDate>(Constants.TEN_YEARS_AGO.toLocalDate(), Constants.IN_TEN_YEARS.toLocalDate());
    private Range<LocalTime> timeRange = new Range<LocalTime>(LocalTime.MIN, LocalTime.MAX);

    public void setDateRange(LocalDate min, LocalDate max) {
        this.dateRange = new Range<LocalDate>(min, max);
    }

    public void setTimeRange(LocalTime min, LocalTime max) {
        this.timeRange = new Range<LocalTime>(min, max);
    }

    public long getSeed() {
        return this.seed;
    }

    public int getMinCollectionSize() {
        return this.minCollectionSize;
    }

    public int getMaxCollectionSize() {
        return this.maxCollectionSize;
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public int getMinStringLength() {
        return this.minStringLength;
    }

    public int getMaxObjectPoolSize() {
        return this.maxObjectPoolSize;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public boolean isScanClasspathForConcreteTypes() {
        return this.scanClasspathForConcreteTypes;
    }

    public boolean isOverrideDefaultInitialization() {
        return this.overrideDefaultInitialization;
    }

    public Range<LocalDate> getDateRange() {
        return this.dateRange;
    }

    public Range<LocalTime> getTimeRange() {
        return this.timeRange;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public void setMinCollectionSize(int minCollectionSize) {
        this.minCollectionSize = minCollectionSize;
    }

    public void setMaxCollectionSize(int maxCollectionSize) {
        this.maxCollectionSize = maxCollectionSize;
    }

    public void setMaxStringLength(int maxStringLength) {
        this.maxStringLength = maxStringLength;
    }

    public void setMinStringLength(int minStringLength) {
        this.minStringLength = minStringLength;
    }

    public void setMaxObjectPoolSize(int maxObjectPoolSize) {
        this.maxObjectPoolSize = maxObjectPoolSize;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setScanClasspathForConcreteTypes(boolean scanClasspathForConcreteTypes) {
        this.scanClasspathForConcreteTypes = scanClasspathForConcreteTypes;
    }

    public void setOverrideDefaultInitialization(boolean overrideDefaultInitialization) {
        this.overrideDefaultInitialization = overrideDefaultInitialization;
    }

    public void setDateRange(Range<LocalDate> dateRange) {
        this.dateRange = dateRange;
    }

    public void setTimeRange(Range<LocalTime> timeRange) {
        this.timeRange = timeRange;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnhancedRandomParameters)) {
            return false;
        }
        EnhancedRandomParameters other = (EnhancedRandomParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSeed() != other.getSeed()) {
            return false;
        }
        if (this.getMinCollectionSize() != other.getMinCollectionSize()) {
            return false;
        }
        if (this.getMaxCollectionSize() != other.getMaxCollectionSize()) {
            return false;
        }
        if (this.getMaxStringLength() != other.getMaxStringLength()) {
            return false;
        }
        if (this.getMinStringLength() != other.getMinStringLength()) {
            return false;
        }
        if (this.getMaxObjectPoolSize() != other.getMaxObjectPoolSize()) {
            return false;
        }
        Charset this$charset = this.getCharset();
        Charset other$charset = other.getCharset();
        if (this$charset == null ? other$charset != null : !((Object)this$charset).equals(other$charset)) {
            return false;
        }
        if (this.isScanClasspathForConcreteTypes() != other.isScanClasspathForConcreteTypes()) {
            return false;
        }
        if (this.isOverrideDefaultInitialization() != other.isOverrideDefaultInitialization()) {
            return false;
        }
        Range<LocalDate> this$dateRange = this.getDateRange();
        Range<LocalDate> other$dateRange = other.getDateRange();
        if (this$dateRange == null ? other$dateRange != null : !((Object)this$dateRange).equals(other$dateRange)) {
            return false;
        }
        Range<LocalTime> this$timeRange = this.getTimeRange();
        Range<LocalTime> other$timeRange = other.getTimeRange();
        return !(this$timeRange == null ? other$timeRange != null : !((Object)this$timeRange).equals(other$timeRange));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EnhancedRandomParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $seed = this.getSeed();
        result = result * 59 + (int)($seed >>> 32 ^ $seed);
        result = result * 59 + this.getMinCollectionSize();
        result = result * 59 + this.getMaxCollectionSize();
        result = result * 59 + this.getMaxStringLength();
        result = result * 59 + this.getMinStringLength();
        result = result * 59 + this.getMaxObjectPoolSize();
        Charset $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : ((Object)$charset).hashCode());
        result = result * 59 + (this.isScanClasspathForConcreteTypes() ? 79 : 97);
        result = result * 59 + (this.isOverrideDefaultInitialization() ? 79 : 97);
        Range<LocalDate> $dateRange = this.getDateRange();
        result = result * 59 + ($dateRange == null ? 43 : ((Object)$dateRange).hashCode());
        Range<LocalTime> $timeRange = this.getTimeRange();
        result = result * 59 + ($timeRange == null ? 43 : ((Object)$timeRange).hashCode());
        return result;
    }

    public String toString() {
        return "EnhancedRandomParameters(seed=" + this.getSeed() + ", minCollectionSize=" + this.getMinCollectionSize() + ", maxCollectionSize=" + this.getMaxCollectionSize() + ", maxStringLength=" + this.getMaxStringLength() + ", minStringLength=" + this.getMinStringLength() + ", maxObjectPoolSize=" + this.getMaxObjectPoolSize() + ", charset=" + this.getCharset() + ", scanClasspathForConcreteTypes=" + this.isScanClasspathForConcreteTypes() + ", overrideDefaultInitialization=" + this.isOverrideDefaultInitialization() + ", dateRange=" + this.getDateRange() + ", timeRange=" + this.getTimeRange() + ")";
    }

    public static class Range<T> {
        private T min;
        private T max;

        public Range(T min, T max) {
            this.min = min;
            this.max = max;
        }

        public T getMin() {
            return this.min;
        }

        public T getMax() {
            return this.max;
        }

        public void setMin(T min) {
            this.min = min;
        }

        public void setMax(T max) {
            this.max = max;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Range)) {
                return false;
            }
            Range other = (Range)o;
            if (!other.canEqual(this)) {
                return false;
            }
            T this$min = this.getMin();
            T other$min = other.getMin();
            if (this$min == null ? other$min != null : !this$min.equals(other$min)) {
                return false;
            }
            T this$max = this.getMax();
            T other$max = other.getMax();
            return !(this$max == null ? other$max != null : !this$max.equals(other$max));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Range;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $min = this.getMin();
            result = result * 59 + ($min == null ? 43 : $min.hashCode());
            T $max = this.getMax();
            result = result * 59 + ($max == null ? 43 : $max.hashCode());
            return result;
        }

        public String toString() {
            return "EnhancedRandomParameters.Range(min=" + this.getMin() + ", max=" + this.getMax() + ")";
        }
    }
}

