/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans;

import io.github.benas.randombeans.EnhancedRandomImpl;
import io.github.benas.randombeans.FieldDefinition;
import io.github.benas.randombeans.FieldDefinitionBuilder;
import io.github.benas.randombeans.RandomizerProxy;
import io.github.benas.randombeans.api.EnhancedRandom;
import io.github.benas.randombeans.api.EnhancedRandomParameters;
import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.api.RandomizerRegistry;
import io.github.benas.randombeans.randomizers.registry.CustomRandomizerRegistry;
import io.github.benas.randombeans.randomizers.registry.ExclusionRandomizerRegistry;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Supplier;

public class EnhancedRandomBuilder {
    private final CustomRandomizerRegistry customRandomizerRegistry = new CustomRandomizerRegistry();
    private final ExclusionRandomizerRegistry exclusionRandomizerRegistry = new ExclusionRandomizerRegistry();
    private final Set<RandomizerRegistry> userRegistries = new LinkedHashSet<RandomizerRegistry>();
    private final EnhancedRandomParameters parameters = new EnhancedRandomParameters();

    public static EnhancedRandomBuilder aNewEnhancedRandomBuilder() {
        return new EnhancedRandomBuilder();
    }

    public static EnhancedRandom aNewEnhancedRandom() {
        return new EnhancedRandomBuilder().build();
    }

    public <T, F, R> EnhancedRandomBuilder randomize(FieldDefinition<T, F> fieldDefinition, Randomizer<R> randomizer) {
        if (fieldDefinition.getType() == null) {
            throw new IllegalArgumentException(String.format("Ambiguous field definition: %s. Field type is mandatory to register a custom randomizer: %s", fieldDefinition, randomizer));
        }
        this.customRandomizerRegistry.registerRandomizer(fieldDefinition, randomizer);
        return this;
    }

    public <T, F, R> EnhancedRandomBuilder randomize(FieldDefinition<T, F> fieldDefinition, Supplier<R> supplier) {
        return this.randomize(fieldDefinition, RandomizerProxy.asRandomizer(supplier));
    }

    public <T, R> EnhancedRandomBuilder randomize(Class<T> type, Randomizer<R> randomizer) {
        this.customRandomizerRegistry.registerRandomizer(type, randomizer);
        return this;
    }

    public <T, R> EnhancedRandomBuilder randomize(Class<T> type, Supplier<R> supplier) {
        return this.randomize(type, RandomizerProxy.asRandomizer(supplier));
    }

    public <T, F> EnhancedRandomBuilder exclude(FieldDefinition<T, F> fieldDefinition) {
        this.exclusionRandomizerRegistry.addFieldDefinition(fieldDefinition);
        return this;
    }

    public EnhancedRandomBuilder exclude(Class<?> ... types) {
        for (Class<?> type : types) {
            this.exclusionRandomizerRegistry.addFieldDefinition(FieldDefinitionBuilder.field().ofType(type).get());
        }
        return this;
    }

    public EnhancedRandomBuilder seed(long seed) {
        this.parameters.setSeed(seed);
        return this;
    }

    public EnhancedRandomBuilder minCollectionSize(int minCollectionSize) {
        if (minCollectionSize < 0) {
            throw new IllegalArgumentException("minCollectionSize must be >= 0");
        }
        this.parameters.setMinCollectionSize(minCollectionSize);
        return this;
    }

    public EnhancedRandomBuilder maxCollectionSize(int maxCollectionSize) {
        this.parameters.setMaxCollectionSize(maxCollectionSize);
        return this;
    }

    public EnhancedRandomBuilder maxStringLength(int maxStringLength) {
        this.parameters.setMaxStringLength(maxStringLength);
        return this;
    }

    public EnhancedRandomBuilder minStringLength(int minStringLength) {
        this.parameters.setMinStringLength(minStringLength);
        return this;
    }

    public EnhancedRandomBuilder maxObjectPoolSize(int maxObjectPoolSize) {
        this.parameters.setMaxObjectPoolSize(maxObjectPoolSize);
        return this;
    }

    public EnhancedRandomBuilder charset(Charset charset) {
        this.parameters.setCharset(charset);
        return this;
    }

    public EnhancedRandomBuilder dateRange(LocalDate min, LocalDate max) {
        this.parameters.setDateRange(min, max);
        return this;
    }

    public EnhancedRandomBuilder timeRange(LocalTime min, LocalTime max) {
        this.parameters.setTimeRange(min, max);
        return this;
    }

    public EnhancedRandomBuilder registerRandomizerRegistry(RandomizerRegistry registry) {
        this.userRegistries.add(registry);
        return this;
    }

    public EnhancedRandomBuilder scanClasspathForConcreteTypes(boolean scanClasspathForConcreteTypes) {
        this.parameters.setScanClasspathForConcreteTypes(scanClasspathForConcreteTypes);
        return this;
    }

    public EnhancedRandomBuilder overrideDefaultInitialization(boolean overrideDefaultInitialization) {
        this.parameters.setOverrideDefaultInitialization(overrideDefaultInitialization);
        return this;
    }

    public EnhancedRandom build() {
        int maxCollectionSize;
        int minCollectionSize = this.parameters.getMinCollectionSize();
        if (minCollectionSize > (maxCollectionSize = this.parameters.getMaxCollectionSize())) {
            throw new IllegalArgumentException(String.format("minCollectionSize (%s) must be <= than maxCollectionSize (%s)", minCollectionSize, maxCollectionSize));
        }
        LinkedHashSet<RandomizerRegistry> registries = this.setupRandomizerRegistries();
        return this.setupEnhancedRandom(registries);
    }

    private EnhancedRandomImpl setupEnhancedRandom(LinkedHashSet<RandomizerRegistry> registries) {
        EnhancedRandomImpl enhancedRandom = new EnhancedRandomImpl(registries);
        enhancedRandom.setParameters(this.parameters);
        return enhancedRandom;
    }

    private LinkedHashSet<RandomizerRegistry> setupRandomizerRegistries() {
        LinkedHashSet<RandomizerRegistry> registries = new LinkedHashSet<RandomizerRegistry>();
        registries.add(this.customRandomizerRegistry);
        registries.add(this.exclusionRandomizerRegistry);
        registries.addAll(this.userRegistries);
        registries.addAll(this.loadRegistries());
        registries.forEach(registry -> registry.init(this.parameters));
        return registries;
    }

    private Collection<RandomizerRegistry> loadRegistries() {
        ArrayList<RandomizerRegistry> registries = new ArrayList<RandomizerRegistry>();
        ServiceLoader.load(RandomizerRegistry.class).forEach(registries::add);
        return registries;
    }
}

