/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.time;

import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.randomizers.time.LocalDateRandomizer;
import io.github.benas.randombeans.randomizers.time.LocalTimeRandomizer;
import io.github.benas.randombeans.randomizers.time.ZoneOffsetRandomizer;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public class OffsetDateTimeRandomizer
implements Randomizer<OffsetDateTime> {
    private final LocalDateRandomizer localDateRandomizer;
    private final LocalTimeRandomizer localTimeRandomizer;
    private final ZoneOffsetRandomizer zoneOffsetRandomizer;

    public OffsetDateTimeRandomizer() {
        this.localDateRandomizer = new LocalDateRandomizer();
        this.localTimeRandomizer = new LocalTimeRandomizer();
        this.zoneOffsetRandomizer = new ZoneOffsetRandomizer();
    }

    public OffsetDateTimeRandomizer(long seed) {
        this.localDateRandomizer = new LocalDateRandomizer(seed);
        this.localTimeRandomizer = new LocalTimeRandomizer(seed);
        this.zoneOffsetRandomizer = new ZoneOffsetRandomizer(seed);
    }

    public static OffsetDateTimeRandomizer aNewOffsetDateTimeRandomizer() {
        return new OffsetDateTimeRandomizer();
    }

    public static OffsetDateTimeRandomizer aNewOffsetDateTimeRandomizer(long seed) {
        return new OffsetDateTimeRandomizer(seed);
    }

    @Override
    public OffsetDateTime getRandomValue() {
        LocalDate randomLocalDate = this.localDateRandomizer.getRandomValue();
        LocalTime randomLocalTime = this.localTimeRandomizer.getRandomValue();
        ZoneOffset randomZoneOffset = this.zoneOffsetRandomizer.getRandomValue();
        return OffsetDateTime.of(randomLocalDate, randomLocalTime, randomZoneOffset);
    }
}

