/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.range;

import io.github.benas.randombeans.randomizers.range.AbstractRangeRandomizer;
import java.util.Date;

public class DateRangeRandomizer
extends AbstractRangeRandomizer<Date> {
    public DateRangeRandomizer(Date min, Date max) {
        super(min, max);
    }

    public DateRangeRandomizer(Date min, Date max, long seed) {
        super(min, max, seed);
    }

    public static DateRangeRandomizer aNewDateRangeRandomizer(Date min, Date max) {
        return new DateRangeRandomizer(min, max);
    }

    public static DateRangeRandomizer aNewDateRangeRandomizer(Date min, Date max, long seed) {
        return new DateRangeRandomizer(min, max, seed);
    }

    @Override
    protected void checkValues() {
        if (((Date)this.min).after((Date)this.max)) {
            throw new IllegalArgumentException("max must be after min");
        }
    }

    @Override
    protected Date getDefaultMinValue() {
        return new Date(Long.MIN_VALUE);
    }

    @Override
    protected Date getDefaultMaxValue() {
        return new Date(Long.MAX_VALUE);
    }

    @Override
    public Date getRandomValue() {
        long minDateTime = ((Date)this.min).getTime();
        long maxDateTime = ((Date)this.max).getTime();
        long randomDateTime = this.nextLong(minDateTime, maxDateTime);
        return new Date(randomDateTime);
    }
}

