/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.api;

import io.github.benas.randombeans.util.Constants;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Random;

public class EnhancedRandomParameters {
    private long seed = new Random().nextLong();
    private int maxCollectionSize = 127;
    private int maxStringLength = 32;
    private Charset charset = StandardCharsets.US_ASCII;
    private boolean scanClasspathForConcreteTypes = false;
    private Range<LocalDate> dateRange = new Range<LocalDate>(Constants.TEN_YEARS_AGO.toLocalDate(), Constants.IN_TEN_YEARS.toLocalDate());
    private Range<LocalTime> timeRange = new Range<LocalTime>(LocalTime.MIN, LocalTime.MAX);

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public int getMaxCollectionSize() {
        return this.maxCollectionSize;
    }

    public void setMaxCollectionSize(int maxCollectionSize) {
        this.maxCollectionSize = maxCollectionSize;
    }

    public boolean isScanClasspathForConcreteTypes() {
        return this.scanClasspathForConcreteTypes;
    }

    public void setScanClasspathForConcreteTypes(boolean scanClasspathForConcreteTypes) {
        this.scanClasspathForConcreteTypes = scanClasspathForConcreteTypes;
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public void setMaxStringLength(int maxStringLength) {
        this.maxStringLength = maxStringLength;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public Range<LocalDate> getDateRange() {
        return this.dateRange;
    }

    public void setDateRange(LocalDate min, LocalDate max) {
        this.dateRange = new Range<LocalDate>(min, max);
    }

    public Range<LocalTime> getTimeRange() {
        return this.timeRange;
    }

    public void setTimeRange(LocalTime min, LocalTime max) {
        this.timeRange = new Range<LocalTime>(min, max);
    }

    public static class Range<T> {
        private T min;
        private T max;

        public Range(T min, T max) {
            this.min = min;
            this.max = max;
        }

        public T getMin() {
            return this.min;
        }

        public T getMax() {
            return this.max;
        }
    }
}

