/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans;

import io.github.benas.randombeans.EnhancedRandomImpl;
import io.github.benas.randombeans.FieldDefinition;
import io.github.benas.randombeans.RandomizerProxy;
import io.github.benas.randombeans.api.EnhancedRandom;
import io.github.benas.randombeans.api.EnhancedRandomParameters;
import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.api.RandomizerRegistry;
import io.github.benas.randombeans.randomizers.misc.SkipRandomizer;
import io.github.benas.randombeans.randomizers.registry.CustomRandomizerRegistry;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Supplier;

public class EnhancedRandomBuilder {
    private final CustomRandomizerRegistry customRandomizerRegistry = new CustomRandomizerRegistry();
    private final Set<RandomizerRegistry> userRegistries = new LinkedHashSet<RandomizerRegistry>();
    private EnhancedRandomParameters parameters = new EnhancedRandomParameters();

    public static EnhancedRandomBuilder aNewEnhancedRandomBuilder() {
        return new EnhancedRandomBuilder();
    }

    public <T, F, R> EnhancedRandomBuilder randomize(FieldDefinition<T, F> fieldDefinition, Randomizer<R> randomizer) {
        this.customRandomizerRegistry.registerRandomizer(fieldDefinition, randomizer);
        return this;
    }

    public <T, F, R> EnhancedRandomBuilder randomize(FieldDefinition<T, F> fieldDefinition, Supplier<R> supplier) {
        return this.randomize(fieldDefinition, RandomizerProxy.asRandomizer(supplier));
    }

    public <T, R> EnhancedRandomBuilder randomize(Class<T> type, Randomizer<R> randomizer) {
        this.customRandomizerRegistry.registerRandomizer(type, randomizer);
        return this;
    }

    public <T, R> EnhancedRandomBuilder randomize(Class<T> type, Supplier<R> supplier) {
        return this.randomize(type, RandomizerProxy.asRandomizer(supplier));
    }

    public <T, F> EnhancedRandomBuilder exclude(FieldDefinition<T, F> fieldDefinition) {
        return this.randomize(fieldDefinition, new SkipRandomizer());
    }

    public EnhancedRandomBuilder seed(long seed) {
        this.parameters.setSeed(seed);
        return this;
    }

    public EnhancedRandomBuilder maxCollectionSize(int maxCollectionSize) {
        this.parameters.setMaxCollectionSize(maxCollectionSize);
        return this;
    }

    public EnhancedRandomBuilder maxStringLength(int maxStringLength) {
        this.parameters.setMaxStringLength(maxStringLength);
        return this;
    }

    public EnhancedRandomBuilder charset(Charset charset) {
        this.parameters.setCharset(charset);
        return this;
    }

    public EnhancedRandomBuilder dateRange(LocalDate min, LocalDate max) {
        this.parameters.setDateRange(min, max);
        return this;
    }

    public EnhancedRandomBuilder timeRange(LocalTime min, LocalTime max) {
        this.parameters.setTimeRange(min, max);
        return this;
    }

    public EnhancedRandomBuilder registerRandomizerRegistry(RandomizerRegistry registry) {
        this.userRegistries.add(registry);
        return this;
    }

    public EnhancedRandomBuilder scanClasspathForConcreteTypes(boolean scanClasspathForConcreteTypes) {
        this.parameters.setScanClasspathForConcreteTypes(scanClasspathForConcreteTypes);
        return this;
    }

    public EnhancedRandom build() {
        LinkedHashSet<RandomizerRegistry> registries = this.setupRandomizerRegistries();
        return this.setupEnhancedRandom(registries);
    }

    private EnhancedRandomImpl setupEnhancedRandom(LinkedHashSet<RandomizerRegistry> registries) {
        EnhancedRandomImpl enhancedRandom = new EnhancedRandomImpl(registries);
        enhancedRandom.setParameters(this.parameters);
        return enhancedRandom;
    }

    private LinkedHashSet<RandomizerRegistry> setupRandomizerRegistries() {
        LinkedHashSet<RandomizerRegistry> registries = new LinkedHashSet<RandomizerRegistry>();
        registries.add(this.customRandomizerRegistry);
        registries.addAll(this.userRegistries);
        registries.addAll(this.loadRegistries());
        registries.forEach(registry -> registry.init(this.parameters));
        return registries;
    }

    private Collection<RandomizerRegistry> loadRegistries() {
        ArrayList<RandomizerRegistry> registries = new ArrayList<RandomizerRegistry>();
        ServiceLoader.load(RandomizerRegistry.class).forEach(registries::add);
        return registries;
    }
}

