/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public abstract class ReflectionUtils {
    private static final ConcurrentHashMap<Class<?>, List<Class<?>>> typeToConcreteSubTypes = new ConcurrentHashMap();
    private static final Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forJavaClassPath()));

    public static <T> List<Field> getDeclaredFields(T type) {
        return new ArrayList<Field>(Arrays.asList(type.getClass().getDeclaredFields()));
    }

    public static List<Field> getInheritedFields(Class<?> type) {
        ArrayList<Field> inheritedFields = new ArrayList<Field>();
        while (type.getSuperclass() != null) {
            Class<?> superclass = type.getSuperclass();
            inheritedFields.addAll(Arrays.asList(superclass.getDeclaredFields()));
            type = superclass;
        }
        return inheritedFields;
    }

    public static void setProperty(Object object, Field field, Object value) throws IllegalAccessException {
        boolean access = field.isAccessible();
        field.setAccessible(true);
        field.set(object, value);
        field.setAccessible(access);
    }

    public static boolean isStatic(Field field) {
        return Modifier.isStatic(field.getModifiers());
    }

    public static boolean isInterface(Class<?> type) {
        return type.isInterface();
    }

    public static <T> boolean isAbstract(Class<T> type) {
        return Modifier.isAbstract(type.getModifiers());
    }

    public static <T> boolean isPublic(Class<T> type) {
        return Modifier.isPublic(type.getModifiers());
    }

    public static boolean isArrayType(Class<?> type) {
        return type.isArray();
    }

    public static boolean isEnumType(Class<?> type) {
        return type.isEnum();
    }

    public static boolean isCollectionType(Class<?> type) {
        return Collection.class.isAssignableFrom(type);
    }

    public static boolean isCollectionType(Type type) {
        return ReflectionUtils.isParameterizedType(type) && ReflectionUtils.isCollectionType((Class)((ParameterizedType)type).getRawType());
    }

    public static boolean isPopulatable(Type type) {
        return !ReflectionUtils.isWildcardType(type) && !ReflectionUtils.isCollectionType(type);
    }

    public static boolean isIntrospectable(Class<?> type) {
        return !ReflectionUtils.isEnumType(type) && !ReflectionUtils.isArrayType(type) && !ReflectionUtils.isCollectionType(type) && !ReflectionUtils.isMapType(type);
    }

    public static boolean isMapType(Class<?> type) {
        return Map.class.isAssignableFrom(type);
    }

    public static boolean isParameterizedType(Type type) {
        return type != null && type instanceof ParameterizedType && ((ParameterizedType)type).getActualTypeArguments().length > 0;
    }

    public static boolean isWildcardType(Type type) {
        return type instanceof WildcardType;
    }

    public static <T> List<Class<?>> getPublicConcreteSubTypesOf(Class<T> type) {
        List<Class<?>> concreteSubTypes = typeToConcreteSubTypes.get(type);
        if (concreteSubTypes == null) {
            concreteSubTypes = ReflectionUtils.searchForPublicConcreteSubTypesOf(type);
            typeToConcreteSubTypes.putIfAbsent(type, Collections.unmodifiableList(concreteSubTypes));
        }
        return concreteSubTypes;
    }

    public static List<Class<?>> filterSameParameterizedTypes(List<Class<?>> types, Type type) {
        if (type instanceof ParameterizedType) {
            Object[] fieldArugmentTypes = ((ParameterizedType)type).getActualTypeArguments();
            ArrayList typesWithSameParameterizedTypes = new ArrayList();
            for (Class<?> currentConcreteType : types) {
                List<Type[]> actualTypeArguments = ReflectionUtils.getActualTypeArgumentsOfGenericInterfaces(currentConcreteType);
                for (Object[] objectArray : actualTypeArguments) {
                    if (!Arrays.equals(fieldArugmentTypes, objectArray)) continue;
                    typesWithSameParameterizedTypes.add(currentConcreteType);
                }
            }
            return typesWithSameParameterizedTypes;
        }
        return types;
    }

    private static <T> List<Class<?>> searchForPublicConcreteSubTypesOf(Class<T> type) {
        Set subTypes = reflections.getSubTypesOf(type);
        ArrayList concreteSubTypes = new ArrayList();
        for (Class currentSubType : subTypes) {
            if (!ReflectionUtils.isPublic(currentSubType) || ReflectionUtils.isAbstract(currentSubType)) continue;
            concreteSubTypes.add(currentSubType);
        }
        return concreteSubTypes;
    }

    private static List<Type[]> getActualTypeArgumentsOfGenericInterfaces(Class<?> type) {
        Type[] genericInterfaceTypes;
        ArrayList<Type[]> actualTypeArguments = new ArrayList<Type[]>();
        for (Type currentGenericInterfaceType : genericInterfaceTypes = type.getGenericInterfaces()) {
            if (!(currentGenericInterfaceType instanceof ParameterizedType)) continue;
            actualTypeArguments.add(((ParameterizedType)currentGenericInterfaceType).getActualTypeArguments());
        }
        return actualTypeArguments;
    }
}

