/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans;

import io.github.benas.randombeans.util.CollectionUtils;
import io.github.benas.randombeans.util.ReflectionUtils;
import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.SynchronousQueue;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;

class ObjectFactory {
    private final Objenesis objenesis = new ObjenesisStd();
    private boolean scanClasspathForConcreteTypes;

    ObjectFactory() {
    }

    <T> T createInstance(Class<T> type) {
        Object result;
        if (this.scanClasspathForConcreteTypes && ReflectionUtils.isAbstract(type)) {
            Class<?> randomConcreteSubType = CollectionUtils.randomElementOf(ReflectionUtils.getPublicConcreteSubTypesOf(type));
            if (randomConcreteSubType == null) {
                throw new InstantiationError("Unable to find a matching concrete subtype of type: " + type + " in the classpath");
            }
            result = this.objenesis.newInstance(randomConcreteSubType);
        } else {
            result = this.objenesis.newInstance(type);
        }
        return (T)result;
    }

    Collection<?> createEmptyCollectionForType(Class<?> fieldType, int initialSize) {
        Collection collection;
        this.rejectUnsupportedTypes(fieldType);
        try {
            collection = (ArrayBlockingQueue)fieldType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            collection = fieldType.equals(ArrayBlockingQueue.class) ? new ArrayBlockingQueue(initialSize) : (Collection)this.objenesis.newInstance(fieldType);
        }
        return collection;
    }

    void setScanClasspathForConcreteTypes(boolean scanClasspathForConcreteTypes) {
        this.scanClasspathForConcreteTypes = scanClasspathForConcreteTypes;
    }

    private void rejectUnsupportedTypes(Class<?> type) {
        if (type.equals(SynchronousQueue.class)) {
            throw new UnsupportedOperationException(SynchronousQueue.class.getName() + " type is not supported");
        }
        if (type.equals(DelayQueue.class)) {
            throw new UnsupportedOperationException(DelayQueue.class.getName() + " type is not supported");
        }
    }
}

