/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans;

import io.github.benas.randombeans.EnhancedRandomImpl;
import io.github.benas.randombeans.FieldDefinition;
import io.github.benas.randombeans.api.EnhancedRandom;
import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.api.RandomizerRegistry;
import io.github.benas.randombeans.randomizers.SkipRandomizer;
import io.github.benas.randombeans.randomizers.registry.CustomRandomizerRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.ServiceLoader;
import java.util.Set;

public class EnhancedRandomBuilder {
    private CustomRandomizerRegistry customRandomizerRegistry = new CustomRandomizerRegistry();
    private Set<RandomizerRegistry> userRegistries = new LinkedHashSet<RandomizerRegistry>();
    private boolean scanClasspathForConcreteTypes = false;
    private long seed = 1234567890L;

    private EnhancedRandomBuilder() {
    }

    public static EnhancedRandomBuilder aNewEnhancedRandomBuilder() {
        return new EnhancedRandomBuilder();
    }

    public <T, F, R> EnhancedRandomBuilder randomize(FieldDefinition<T, F> fieldDefinition, Randomizer<R> randomizer) {
        this.customRandomizerRegistry.registerRandomizer(fieldDefinition.getName(), fieldDefinition.getType(), fieldDefinition.getClazz(), randomizer);
        return this;
    }

    public <T, F> EnhancedRandomBuilder exclude(FieldDefinition<T, F> fieldDefinition) {
        return this.randomize(fieldDefinition, new SkipRandomizer());
    }

    public EnhancedRandomBuilder seed(long seed) {
        this.seed = seed;
        return this;
    }

    public EnhancedRandomBuilder registerRandomizerRegistry(RandomizerRegistry registry) {
        this.userRegistries.add(registry);
        return this;
    }

    public EnhancedRandomBuilder scanClasspathForConcreteTypes(boolean scanClasspathForConcreteTypes) {
        this.scanClasspathForConcreteTypes = scanClasspathForConcreteTypes;
        return this;
    }

    public EnhancedRandom build() {
        LinkedHashSet<RandomizerRegistry> registries = new LinkedHashSet<RandomizerRegistry>();
        registries.add(this.customRandomizerRegistry);
        registries.addAll(this.userRegistries);
        registries.addAll(this.loadRegistries());
        for (RandomizerRegistry registry : registries) {
            registry.setSeed(this.seed);
        }
        EnhancedRandomImpl enhancedRandom = new EnhancedRandomImpl(registries);
        enhancedRandom.setSeed(this.seed);
        enhancedRandom.setScanClasspathForConcreteTypes(this.scanClasspathForConcreteTypes);
        return enhancedRandom;
    }

    private Collection<RandomizerRegistry> loadRegistries() {
        ArrayList<RandomizerRegistry> registries = new ArrayList<RandomizerRegistry>();
        ServiceLoader<RandomizerRegistry> loader = ServiceLoader.load(RandomizerRegistry.class);
        for (RandomizerRegistry registry : loader) {
            registries.add(registry);
        }
        return registries;
    }
}

