/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.jpopulator.randomizers.validation;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.math3.random.RandomDataGenerator;

public class MaxValueRandomizer {
    private static RandomDataGenerator randomDataGenerator = new RandomDataGenerator();

    private MaxValueRandomizer() {
    }

    public static Object getRandomValue(Class type, long maxValue) {
        if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
            return (byte)randomDataGenerator.nextLong(-128L, maxValue);
        }
        if (type.equals(Short.TYPE) || type.equals(Short.class)) {
            return (short)randomDataGenerator.nextLong(-32768L, maxValue);
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return (int)randomDataGenerator.nextLong(Integer.MIN_VALUE, maxValue);
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return randomDataGenerator.nextLong(Long.MIN_VALUE, maxValue);
        }
        if (type.equals(BigInteger.class)) {
            return new BigInteger(String.valueOf(randomDataGenerator.nextLong(Long.MIN_VALUE, maxValue)));
        }
        if (type.equals(BigDecimal.class)) {
            return new BigDecimal(randomDataGenerator.nextLong(Long.MIN_VALUE, maxValue));
        }
        return null;
    }
}

