/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.jpopulator.randomizers;

import io.github.benas.jpopulator.api.Randomizer;
import java.util.Date;
import org.apache.commons.math3.random.RandomDataGenerator;

public class DateRangeRandomizer
implements Randomizer<Date> {
    private final Date minDate;
    private final Date maxDate;

    public DateRangeRandomizer(Date minDate, Date maxDate) {
        if (minDate == null) {
            throw new IllegalArgumentException("minDate must not be null");
        }
        if (maxDate == null) {
            throw new IllegalArgumentException("maxDate must not be null");
        }
        if (minDate.after(maxDate)) {
            throw new IllegalArgumentException("minDate must be before maxDate");
        }
        this.minDate = minDate;
        this.maxDate = maxDate;
    }

    @Override
    public Date getRandomValue() {
        long minDateTime = this.minDate.getTime();
        long maxDateTime = this.maxDate.getTime();
        long randomDateTime = new RandomDataGenerator().nextLong(minDateTime, maxDateTime);
        return new Date(randomDateTime);
    }
}

