/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.jpopulator.impl;

import io.github.benas.jpopulator.randomizers.UriRandomizer;
import io.github.benas.jpopulator.randomizers.UrlRandomizer;
import io.github.benas.jpopulator.util.ConstantsUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.RandomStringUtils;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.Period;

final class DefaultRandomizer {
    private static final Logger LOGGER = Logger.getLogger(DefaultRandomizer.class.getName());
    private static UrlRandomizer urlRandomizer = new UrlRandomizer();
    private static UriRandomizer uriRandomizer = new UriRandomizer();

    private DefaultRandomizer() {
    }

    public static Object getRandomValue(Class type) {
        if (type.equals(String.class)) {
            return RandomStringUtils.randomAlphabetic((int)10);
        }
        if (type.equals(Character.TYPE) || type.equals(Character.class)) {
            return Character.valueOf(RandomStringUtils.randomAlphabetic((int)1).charAt(0));
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return ConstantsUtil.RANDOM.nextBoolean();
        }
        if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
            return (byte)ConstantsUtil.RANDOM.nextInt();
        }
        if (type.equals(Short.TYPE) || type.equals(Short.class)) {
            return (short)ConstantsUtil.RANDOM.nextInt();
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return ConstantsUtil.RANDOM.nextInt();
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return ConstantsUtil.RANDOM.nextLong();
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return ConstantsUtil.RANDOM.nextDouble();
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return Float.valueOf(ConstantsUtil.RANDOM.nextFloat());
        }
        if (type.equals(BigInteger.class)) {
            return new BigInteger(Math.abs(ConstantsUtil.RANDOM.nextInt(100)), ConstantsUtil.RANDOM);
        }
        if (type.equals(BigDecimal.class)) {
            return new BigDecimal(ConstantsUtil.RANDOM.nextDouble());
        }
        if (type.equals(AtomicLong.class)) {
            return new AtomicLong(ConstantsUtil.RANDOM.nextLong());
        }
        if (type.equals(AtomicInteger.class)) {
            return new AtomicInteger(ConstantsUtil.RANDOM.nextInt());
        }
        if (type.equals(java.util.Date.class)) {
            return ConstantsUtil.DATE_RANGE_RANDOMIZER.getRandomValue();
        }
        if (type.equals(Date.class)) {
            return new Date(ConstantsUtil.DATE_RANGE_RANDOMIZER.getRandomValue().getTime());
        }
        if (type.equals(Time.class)) {
            return new Time(ConstantsUtil.RANDOM.nextLong());
        }
        if (type.equals(Timestamp.class)) {
            return new Timestamp(ConstantsUtil.DATE_RANGE_RANDOMIZER.getRandomValue().getTime());
        }
        if (type.equals(Calendar.class)) {
            return Calendar.getInstance();
        }
        if (type.equals(DateTime.class)) {
            return new DateTime(ConstantsUtil.DATE_RANGE_RANDOMIZER.getRandomValue().getTime());
        }
        if (type.equals(LocalDate.class)) {
            return new LocalDate(ConstantsUtil.DATE_RANGE_RANDOMIZER.getRandomValue().getTime());
        }
        if (type.equals(LocalTime.class)) {
            return new LocalTime(ConstantsUtil.DATE_RANGE_RANDOMIZER.getRandomValue().getTime());
        }
        if (type.equals(LocalDateTime.class)) {
            return new LocalDateTime(ConstantsUtil.DATE_RANGE_RANDOMIZER.getRandomValue().getTime());
        }
        if (type.equals(Duration.class)) {
            return new Duration(Math.abs(ConstantsUtil.RANDOM.nextLong()));
        }
        if (type.equals(Period.class)) {
            return new Period((long)Math.abs(ConstantsUtil.RANDOM.nextInt()));
        }
        if (type.equals(Interval.class)) {
            long startDate = Math.abs(ConstantsUtil.RANDOM.nextInt());
            long endDate = startDate + (long)Math.abs(ConstantsUtil.RANDOM.nextInt());
            return new Interval(startDate, endDate);
        }
        if (type.equals(URL.class)) {
            try {
                return new URL(urlRandomizer.getRandomValue());
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.WARNING, "The generated URL is malformed, the field will be set to null", e);
                return null;
            }
        }
        if (type.equals(URI.class)) {
            try {
                return new URI(uriRandomizer.getRandomValue());
            }
            catch (URISyntaxException e) {
                LOGGER.log(Level.WARNING, "The generated URI is malformed, the field will be set to null", e);
                return null;
            }
        }
        if (type.isEnum() && type.getEnumConstants().length > 0) {
            T[] enumConstants = type.getEnumConstants();
            return enumConstants[ConstantsUtil.RANDOM.nextInt(enumConstants.length)];
        }
        return null;
    }
}

