package io.github.baharmc.chat

import org.hjson.JsonObject
import org.hjson.JsonValue

class HoverEvent(val action: HoverAction, val value: JsonValue) {

    companion object {

        fun text(text: String) = text(ChatComponent.text(text))

        fun text(chat: ChatComponent) = HoverEvent(HoverAction.SHOW_TEXT, chat.asJson())

        fun achievement(achievement: String) = HoverEvent(HoverAction.SHOW_ACHIEVEMENT, JsonValue.valueOf(achievement))

//        fun item(item: Item): HoverEvent {
//            val json = JsonObject()
//            json.add("id", item.getSubstance().toString().replaceAll("minecraft:", ""))
//            json.add("Damage", item.getDamage())
//            json.add("Count", item.getCount())
//            json.add("tag", "{}")
//            return HoverEvent(
//                HoverAction.SHOW_ITEM,
//                JsonValue.valueOf(json.toString().replace("\"".toRegex(), ""))
//            )
//        }

        fun fromJson(json: JsonValue) = HoverEvent(
            HoverAction.valueOf(json.asObject()["action"].asString().toUpperCase()),
            json.asObject()["value"]
        )

    }

    fun asJson(): JsonValue {
        val obj = JsonObject()
        obj.add("action", action.name.toLowerCase())
        obj.add("value", value)
        return obj
    }

}