package io.github.baharmc.chat

enum class ClientChatMode(val data: Int) {

    CHAT_AND_COMMANDS(0),

    COMMANDS_ONLY(1),

    NONE(2);

    companion object {

        fun of(data: Int): ClientChatMode = values().asList()
            .stream()
            .filter { it.data === data }
            .findFirst()
            .orElseThrow {
                IllegalArgumentException("no client chat mode with id=$data")
            }

    }

}