package io.github.baharmc.chat

enum class ChatColor(val colorChar: Char) {

    BLACK('0'),

    DARK_BLUE('1'),

    DARK_GREEN('2'),

    DARK_AQUA('3'),

    DARK_RED('4'),

    DARK_PURPLE('5'),

    GOLD('6'),

    GRAY('7'),

    DARK_GRAY('8'),

    BLUE('9'),

    GREEN('a'),

    AQUA('b'),

    RED('c'),

    LIGHT_PURPLE('d'),

    YELLOW('e'),

    WHITE('f'),

    OBFUSCATED('k'),

    BOLD('l'),

    STRIKETHROUGH('m'),

    UNDERLINE('n'),

    ITALIC('o'),

    RESET('r');

    companion object {

        const val escape = '\u00A7'

        fun of(colorChar: Char) = values().asList()
            .stream()
            .filter { it.colorChar == colorChar }
            .findFirst()
            .orElseThrow {
                IllegalArgumentException("no color with character $colorChar")
            }

    }

    fun isFormat() = colorChar in 'k'..'r'

    fun isColor() = !isFormat()

    override fun toString() = escape.toString() + colorChar

}