/*
 * Decompiled with CFR 0.152.
 */
package com.azhon.appupdate.util;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.net.Uri;
import android.os.Build;
import androidx.core.content.FileProvider;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/azhon/appupdate/util/ApkUtil;", "", "()V", "Companion", "appupdate_release"})
public final class ApkUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0014"}, d2={"Lcom/azhon/appupdate/util/ApkUtil$Companion;", "", "()V", "createInstallIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "authorities", "", "apk", "Ljava/io/File;", "deleteOldApk", "", "oldApkPath", "getVersionCode", "", "getVersionCodeByPath", "path", "installApk", "", "appupdate_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void installApk(@NotNull Context context, @NotNull String authorities, @NotNull File apk) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)authorities, (String)"authorities");
            Intrinsics.checkNotNullParameter((Object)apk, (String)"apk");
            context.startActivity(this.createInstallIntent(context, authorities, apk));
        }

        @NotNull
        public final Intent createInstallIntent(@NotNull Context context, @NotNull String authorities, @NotNull File apk) {
            Intent intent;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)authorities, (String)"authorities");
            Intrinsics.checkNotNullParameter((Object)apk, (String)"apk");
            Intent $this$createInstallIntent_u24lambda_u2d0 = intent = new Intent();
            boolean bl = false;
            $this$createInstallIntent_u24lambda_u2d0.setAction("android.intent.action.VIEW");
            $this$createInstallIntent_u24lambda_u2d0.addFlags(0x10000000);
            $this$createInstallIntent_u24lambda_u2d0.addCategory("android.intent.category.DEFAULT");
            Intent intent2 = intent;
            Uri uri = null;
            if (Build.VERSION.SDK_INT >= 24) {
                Uri uri2 = FileProvider.getUriForFile((Context)context, (String)authorities, (File)apk);
                Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"getUriForFile(context, authorities, apk)");
                uri = uri2;
                intent2.addFlags(1);
            } else {
                Uri uri3 = Uri.fromFile((File)apk);
                Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"fromFile(apk)");
                uri = uri3;
            }
            intent2.setDataAndType(uri, "application/vnd.android.package-archive");
            return intent2;
        }

        public final long getVersionCode(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            if (Build.VERSION.SDK_INT < 28) {
                return packageInfo.versionCode;
            }
            return packageInfo.getLongVersionCode();
        }

        public final boolean deleteOldApk(@NotNull Context context, @NotNull String oldApkPath) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)oldApkPath, (String)"oldApkPath");
            long curVersionCode = this.getVersionCode(context);
            try {
                long oldVersionCode;
                File apk = new File(oldApkPath);
                if (apk.exists() && curVersionCode > (oldVersionCode = this.getVersionCodeByPath(context, oldApkPath))) {
                    return apk.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        private final long getVersionCodeByPath(Context context, String path) {
            PackageInfo packageInfo;
            PackageInfo packageInfo2 = context.getPackageManager().getPackageArchiveInfo(path, 1);
            if (Build.VERSION.SDK_INT >= 28) {
                packageInfo = packageInfo2;
            } else {
                PackageInfo packageInfo3 = packageInfo2;
                return packageInfo3 != null ? (long)packageInfo3.versionCode : 1L;
            }
            return packageInfo != null ? packageInfo.getLongVersionCode() : 1L;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

