/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.sources;

import io.github.ascopes.protobufmavenplugin.utils.FileUtils;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

final class SourceGlobFilter {
    private final List<PathMatcher> includes;
    private final List<PathMatcher> excludes;

    SourceGlobFilter(List<String> includes, List<String> excludes) {
        this.includes = SourceGlobFilter.compileMatchers(includes);
        this.excludes = SourceGlobFilter.compileMatchers(excludes);
    }

    boolean matches(Path relativeRoot, Path file) {
        Path relativeFile = relativeRoot.relativize(file);
        if (this.excludes.stream().anyMatch(SourceGlobFilter.forPath(relativeFile))) {
            return false;
        }
        if (!this.includes.isEmpty() && this.includes.stream().noneMatch(SourceGlobFilter.forPath(relativeFile))) {
            return false;
        }
        return Files.isRegularFile(file, new LinkOption[0]) && FileUtils.getFileExtension(file).filter(".proto"::equalsIgnoreCase).isPresent();
    }

    private static List<PathMatcher> compileMatchers(List<String> patterns) {
        return patterns.stream().map("glob:"::concat).map(FileSystems.getDefault()::getPathMatcher).collect(Collectors.toUnmodifiableList());
    }

    private static Predicate<PathMatcher> forPath(Path path) {
        return matcher -> matcher.matches(path);
    }
}

