/*
 * Decompiled with CFR 0.152.
 */
package io.github.anderscheow.library.utils;

import android.support.annotation.AnyThread;
import android.support.annotation.GuardedBy;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import java.util.Arrays;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public class PagingRequestHelper {
    private final Object mLock = new Object();
    private final Executor mRetryService;
    @GuardedBy(value="mLock")
    private final RequestQueue[] mRequestQueues = new RequestQueue[]{new RequestQueue(RequestType.INITIAL), new RequestQueue(RequestType.BEFORE), new RequestQueue(RequestType.AFTER)};
    @NonNull
    final CopyOnWriteArrayList<Listener> mListeners = new CopyOnWriteArrayList();

    public PagingRequestHelper(@NonNull Executor retryService) {
        this.mRetryService = retryService;
    }

    @AnyThread
    public boolean addListener(@NonNull Listener listener) {
        return this.mListeners.add(listener);
    }

    public boolean removeListener(@NonNull Listener listener) {
        return this.mListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public boolean runIfNotRunning(@NonNull RequestType type, @NonNull Request request) {
        boolean hasListeners = !this.mListeners.isEmpty();
        StatusReport report = null;
        Object object = this.mLock;
        synchronized (object) {
            RequestQueue queue = this.mRequestQueues[type.ordinal()];
            if (queue.mRunning != null) {
                return false;
            }
            queue.mRunning = request;
            queue.mStatus = Status.RUNNING;
            queue.mFailed = null;
            queue.mLastError = null;
            if (hasListeners) {
                report = this.prepareStatusReportLocked();
            }
        }
        if (report != null) {
            this.dispatchReport(report);
        }
        RequestWrapper wrapper = new RequestWrapper(request, this, type);
        wrapper.run();
        return true;
    }

    @GuardedBy(value="mLock")
    private StatusReport prepareStatusReportLocked() {
        String[] errors = new String[]{this.mRequestQueues[0].mLastError, this.mRequestQueues[1].mLastError, this.mRequestQueues[2].mLastError};
        return new StatusReport(this.getStatusForLocked(RequestType.INITIAL), this.getStatusForLocked(RequestType.BEFORE), this.getStatusForLocked(RequestType.AFTER), errors);
    }

    @GuardedBy(value="mLock")
    private Status getStatusForLocked(RequestType type) {
        return this.mRequestQueues[type.ordinal()].mStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    @VisibleForTesting
    void recordResult(@NonNull RequestWrapper wrapper, @Nullable String errorMessage) {
        StatusReport report = null;
        boolean success = errorMessage == null;
        boolean hasListeners = !this.mListeners.isEmpty();
        Object object = this.mLock;
        synchronized (object) {
            RequestQueue queue = this.mRequestQueues[wrapper.mType.ordinal()];
            queue.mRunning = null;
            queue.mLastError = errorMessage;
            if (success) {
                queue.mFailed = null;
                queue.mStatus = Status.SUCCESS;
            } else {
                queue.mFailed = wrapper;
                queue.mStatus = Status.FAILED;
            }
            if (hasListeners) {
                report = this.prepareStatusReportLocked();
            }
        }
        if (report != null) {
            this.dispatchReport(report);
        }
    }

    private void dispatchReport(StatusReport report) {
        for (Listener listener : this.mListeners) {
            listener.onStatusChange(report);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retryAllFailed() {
        RequestWrapper[] toBeRetried = new RequestWrapper[RequestType.values().length];
        boolean retried = false;
        RequestWrapper[] requestWrapperArray = this.mLock;
        synchronized (this.mLock) {
            for (int i = 0; i < RequestType.values().length; ++i) {
                toBeRetried[i] = this.mRequestQueues[i].mFailed;
                this.mRequestQueues[i].mFailed = null;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            for (RequestWrapper failed : toBeRetried) {
                if (failed == null) continue;
                failed.retry(this.mRetryService);
                retried = true;
            }
            return retried;
        }
    }

    class RequestQueue {
        @NonNull
        final RequestType mRequestType;
        @Nullable
        RequestWrapper mFailed;
        @Nullable
        Request mRunning;
        @Nullable
        String mLastError;
        @NonNull
        Status mStatus = Status.SUCCESS;

        RequestQueue(RequestType requestType) {
            this.mRequestType = requestType;
        }
    }

    public static enum RequestType {
        INITIAL,
        BEFORE,
        AFTER;

    }

    public static enum Status {
        RUNNING,
        SUCCESS,
        FAILED;

    }

    public static interface Listener {
        public void onStatusChange(@NonNull StatusReport var1);
    }

    public static final class StatusReport {
        @NonNull
        public final Status initial;
        @NonNull
        public final Status before;
        @NonNull
        public final Status after;
        @NonNull
        private final String[] mErrors;

        StatusReport(@NonNull Status initial, @NonNull Status before, @NonNull Status after, @NonNull String[] errors) {
            this.initial = initial;
            this.before = before;
            this.after = after;
            this.mErrors = errors;
        }

        public boolean hasRunning() {
            return this.initial == Status.RUNNING || this.before == Status.RUNNING || this.after == Status.RUNNING;
        }

        public boolean hasError() {
            return this.initial == Status.FAILED || this.before == Status.FAILED || this.after == Status.FAILED;
        }

        @Nullable
        public String getErrorFor(@NonNull RequestType type) {
            return this.mErrors[type.ordinal()];
        }

        public String toString() {
            return "StatusReport{initial=" + (Object)((Object)this.initial) + ", before=" + (Object)((Object)this.before) + ", after=" + (Object)((Object)this.after) + ", mErrors=" + Arrays.toString(this.mErrors) + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StatusReport that = (StatusReport)o;
            if (this.initial != that.initial) {
                return false;
            }
            if (this.before != that.before) {
                return false;
            }
            if (this.after != that.after) {
                return false;
            }
            return Arrays.equals(this.mErrors, that.mErrors);
        }

        public int hashCode() {
            int result = this.initial.hashCode();
            result = 31 * result + this.before.hashCode();
            result = 31 * result + this.after.hashCode();
            result = 31 * result + Arrays.hashCode(this.mErrors);
            return result;
        }
    }

    @FunctionalInterface
    public static interface Request {
        public void run(Callback var1);

        public static class Callback {
            private final AtomicBoolean mCalled = new AtomicBoolean();
            private final RequestWrapper mWrapper;
            private final PagingRequestHelper mHelper;

            Callback(RequestWrapper wrapper, PagingRequestHelper helper) {
                this.mWrapper = wrapper;
                this.mHelper = helper;
            }

            public final void recordSuccess() {
                if (!this.mCalled.compareAndSet(false, true)) {
                    throw new IllegalStateException("already called recordSuccess or recordFailure");
                }
                this.mHelper.recordResult(this.mWrapper, null);
            }

            public final void recordFailure(@NonNull String errorMessage) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException("You must provide a throwable describing the error to record the failure");
                }
                if (!this.mCalled.compareAndSet(false, true)) {
                    throw new IllegalStateException("already called recordSuccess or recordFailure");
                }
                this.mHelper.recordResult(this.mWrapper, errorMessage);
            }
        }
    }

    static class RequestWrapper
    implements Runnable {
        @NonNull
        final Request mRequest;
        @NonNull
        final PagingRequestHelper mHelper;
        @NonNull
        final RequestType mType;

        RequestWrapper(@NonNull Request request, @NonNull PagingRequestHelper helper, @NonNull RequestType type) {
            this.mRequest = request;
            this.mHelper = helper;
            this.mType = type;
        }

        @Override
        public void run() {
            this.mRequest.run(new Request.Callback(this, this.mHelper));
        }

        void retry(Executor service) {
            service.execute(new Runnable(){

                @Override
                public void run() {
                    mHelper.runIfNotRunning(mType, mRequest);
                }
            });
        }
    }
}

