/*
 * Decompiled with CFR 0.152.
 */
package io.github.anderscheow.library.paging;

import android.arch.lifecycle.LiveData;
import android.arch.paging.PagedList;
import android.support.annotation.MainThread;
import io.github.anderscheow.library.constant.NetworkState;
import io.github.anderscheow.library.paging.BoundaryCallback;
import io.github.anderscheow.library.paging.PagingModel;
import io.github.anderscheow.library.utils.PagingRequestHelper;
import io.github.anderscheow.library.utils.PagingRequestHelperExtKt;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0007\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B=\u0012\u001a\u0010\u0004\u001a\u0016\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\u0018\u001a\u00020\u00072\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J>\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0018\u0010\u001d\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00070\u0005H&J\u0015\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00028\u0000H\u0017\u00a2\u0006\u0002\u0010\"J\u0015\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\"J\b\u0010%\u001a\u00020\u0007H\u0017R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0004\u001a\u0016\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/github/anderscheow/library/paging/BoundaryCallback;", "T", "Lio/github/anderscheow/library/paging/PagingModel;", "Landroid/arch/paging/PagedList$BoundaryCallback;", "handleResponse", "Lkotlin/Function1;", "", "", "totalItems", "", "executor", "Ljava/util/concurrent/Executor;", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Ljava/util/concurrent/Executor;)V", "helper", "Lio/github/anderscheow/library/utils/PagingRequestHelper;", "getHelper", "()Lio/github/anderscheow/library/utils/PagingRequestHelper;", "networkState", "Landroid/arch/lifecycle/LiveData;", "Lio/github/anderscheow/library/constant/NetworkState;", "getNetworkState", "()Landroid/arch/lifecycle/LiveData;", "pageNumber", "", "insertItemsIntoDb", "response", "callback", "Lio/github/anderscheow/library/utils/PagingRequestHelper$Request$Callback;", "loadItemsSynchronously", "success", "failed", "", "onItemAtEndLoaded", "itemAtEnd", "(Lio/github/anderscheow/library/paging/PagingModel;)V", "onItemAtFrontLoaded", "itemAtFront", "onZeroItemsLoaded", "library_release"})
public abstract class BoundaryCallback<T extends PagingModel>
extends PagedList.BoundaryCallback<T> {
    @NotNull
    private final PagingRequestHelper helper;
    @NotNull
    private final LiveData<NetworkState> networkState;
    private int pageNumber;
    private final Function1<List<? extends T>, Unit> handleResponse;
    private final Function1<Long, Unit> totalItems;
    private final Executor executor;

    @NotNull
    public final PagingRequestHelper getHelper() {
        return this.helper;
    }

    @NotNull
    public final LiveData<NetworkState> getNetworkState() {
        return this.networkState;
    }

    public abstract void loadItemsSynchronously(int var1, @NotNull Function1<? super List<? extends T>, Unit> var2, @NotNull Function1<? super Throwable, Unit> var3);

    @MainThread
    public void onZeroItemsLoaded() {
        this.helper.runIfNotRunning(PagingRequestHelper.RequestType.INITIAL, new PagingRequestHelper.Request(this){
            final /* synthetic */ BoundaryCallback this$0;

            public final void run(PagingRequestHelper.Request.Callback callback) {
                this.this$0.loadItemsSynchronously(BoundaryCallback.access$getPageNumber$p(this.this$0), (Function1)new Function1<List<? extends T>, Unit>(this, callback){
                    final /* synthetic */ onZeroItemsLoaded.1 this$0;
                    final /* synthetic */ PagingRequestHelper.Request.Callback $callback;

                    public final void invoke(@NotNull List<? extends T> items) {
                        Intrinsics.checkParameterIsNotNull(items, (String)"items");
                        BoundaryCallback boundaryCallback = this.this$0.this$0;
                        PagingRequestHelper.Request.Callback callback = this.$callback;
                        Intrinsics.checkExpressionValueIsNotNull((Object)callback, (String)"callback");
                        BoundaryCallback.access$insertItemsIntoDb(boundaryCallback, items, callback);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$callback = callback;
                        super(1);
                    }
                }, (Function1<Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(callback){
                    final /* synthetic */ PagingRequestHelper.Request.Callback $callback;

                    public final void invoke(@NotNull Throwable it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        this.$callback.recordFailure(it);
                    }
                    {
                        this.$callback = callback;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = boundaryCallback;
            }
        });
    }

    @MainThread
    public void onItemAtEndLoaded(@NotNull T itemAtEnd) {
        Intrinsics.checkParameterIsNotNull(itemAtEnd, (String)"itemAtEnd");
        this.helper.runIfNotRunning(PagingRequestHelper.RequestType.AFTER, new PagingRequestHelper.Request(this){
            final /* synthetic */ BoundaryCallback this$0;

            public final void run(PagingRequestHelper.Request.Callback callback) {
                this.this$0.loadItemsSynchronously(BoundaryCallback.access$getPageNumber$p(this.this$0), (Function1)new Function1<List<? extends T>, Unit>(this, callback){
                    final /* synthetic */ onItemAtEndLoaded.1 this$0;
                    final /* synthetic */ PagingRequestHelper.Request.Callback $callback;

                    public final void invoke(@NotNull List<? extends T> items) {
                        Intrinsics.checkParameterIsNotNull(items, (String)"items");
                        BoundaryCallback boundaryCallback = this.this$0.this$0;
                        PagingRequestHelper.Request.Callback callback = this.$callback;
                        Intrinsics.checkExpressionValueIsNotNull((Object)callback, (String)"callback");
                        BoundaryCallback.access$insertItemsIntoDb(boundaryCallback, items, callback);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$callback = callback;
                        super(1);
                    }
                }, (Function1<Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(callback){
                    final /* synthetic */ PagingRequestHelper.Request.Callback $callback;

                    public final void invoke(@NotNull Throwable it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        this.$callback.recordFailure(it);
                    }
                    {
                        this.$callback = callback;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = boundaryCallback;
            }
        });
    }

    public void onItemAtFrontLoaded(@NotNull T itemAtFront) {
        Intrinsics.checkParameterIsNotNull(itemAtFront, (String)"itemAtFront");
    }

    private final void insertItemsIntoDb(List<? extends T> response, PagingRequestHelper.Request.Callback callback) {
        this.executor.execute(new Runnable(this, response, callback){
            final /* synthetic */ BoundaryCallback this$0;
            final /* synthetic */ List $response;
            final /* synthetic */ PagingRequestHelper.Request.Callback $callback;

            public final void run() {
                BoundaryCallback.access$getHandleResponse$p(this.this$0).invoke((Object)this.$response);
                this.$callback.recordSuccess();
                BoundaryCallback boundaryCallback = this.this$0;
                BoundaryCallback.access$setPageNumber$p(boundaryCallback, BoundaryCallback.access$getPageNumber$p(boundaryCallback) + 1);
            }
            {
                this.this$0 = boundaryCallback;
                this.$response = list;
                this.$callback = callback;
            }
        });
    }

    public BoundaryCallback(@NotNull Function1<? super List<? extends T>, Unit> handleResponse, @NotNull Function1<? super Long, Unit> totalItems, @NotNull Executor executor) {
        Intrinsics.checkParameterIsNotNull(handleResponse, (String)"handleResponse");
        Intrinsics.checkParameterIsNotNull(totalItems, (String)"totalItems");
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        this.handleResponse = handleResponse;
        this.totalItems = totalItems;
        this.executor = executor;
        this.helper = new PagingRequestHelper(this.executor);
        this.networkState = PagingRequestHelperExtKt.createStatusLiveData(this.helper);
        this.pageNumber = 1;
    }

    public static final /* synthetic */ int access$getPageNumber$p(BoundaryCallback $this) {
        return $this.pageNumber;
    }

    public static final /* synthetic */ void access$setPageNumber$p(BoundaryCallback $this, int n) {
        $this.pageNumber = n;
    }

    public static final /* synthetic */ void access$insertItemsIntoDb(BoundaryCallback $this, @NotNull List response, @NotNull PagingRequestHelper.Request.Callback callback) {
        $this.insertItemsIntoDb(response, callback);
    }

    @NotNull
    public static final /* synthetic */ Function1 access$getHandleResponse$p(BoundaryCallback $this) {
        return $this.handleResponse;
    }
}

