/*
 * Decompiled with CFR 0.152.
 */
package uk.co.certait.htmlexporter.writer.ods;

import org.jsoup.nodes.Element;
import org.odftoolkit.simple.table.Cell;
import org.odftoolkit.simple.table.Table;
import uk.co.certait.htmlexporter.css.Style;
import uk.co.certait.htmlexporter.css.StyleMap;
import uk.co.certait.htmlexporter.ss.CellRange;
import uk.co.certait.htmlexporter.ss.Function;
import uk.co.certait.htmlexporter.writer.AbstractTableCellWriter;
import uk.co.certait.htmlexporter.writer.ods.OdsCellRangeResolver;
import uk.co.certait.htmlexporter.writer.ods.OdsFunctionCell;
import uk.co.certait.htmlexporter.writer.ods.OdsStyleGenerator;

public class OdsTableCellWriter
extends AbstractTableCellWriter {
    private Table table;
    private StyleMap styleMapper;
    private OdsStyleGenerator styleGenerator;

    public OdsTableCellWriter(Table table, StyleMap styleMapper) {
        this.table = table;
        this.styleMapper = styleMapper;
        this.styleGenerator = new OdsStyleGenerator();
    }

    @Override
    public void renderCell(Element element, int rowIndex, int columnIndex) {
        Cell cell = this.table.getCellByPosition(columnIndex, rowIndex);
        Double numericValue = null;
        numericValue = this.getNumericValue(element);
        if (numericValue != null) {
            cell.setDoubleValue(numericValue);
        } else {
            cell.setStringValue(this.getElementText(element));
        }
        Style style = this.styleMapper.getStyleForElement(element);
        this.styleGenerator.styleCell(cell, style);
        String commentText = this.getCellCommentText(element);
        if (commentText != null) {
            cell.setNoteText(commentText);
        }
    }

    @Override
    public void addFunctionCell(int rowIndex, int columnIndex, CellRange range, Function function) {
        Cell cell = this.table.getCellByPosition(columnIndex, rowIndex);
        new OdsFunctionCell(cell, range, new OdsCellRangeResolver(), function);
    }
}

