/*
 * Decompiled with CFR 0.152.
 */
package uk.co.certait.htmlexporter.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import uk.co.certait.htmlexporter.css.StyleMap;
import uk.co.certait.htmlexporter.css.StyleParser;
import uk.co.certait.htmlexporter.writer.Exporter;

public abstract class AbstractExporter
implements Exporter {
    private static final String DATA_NEW_SHEET_ATTRIBUTE = "data-new-sheet";
    private static final String DATA_SHEET_NAME_ATTRIBUTE = "data-sheet-name";

    @Override
    public byte[] exportHtml(String html) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.exportHtml(html, (OutputStream)out);
        return out.toByteArray();
    }

    @Override
    public void exportHtml(String html, File outputFile) throws IOException {
        FileOutputStream out = new FileOutputStream(outputFile);
        this.exportHtml(html, out);
    }

    protected Elements getTables(String html) {
        Document document = Jsoup.parse((String)html);
        return document.getElementsByTag("table");
    }

    protected StyleMap getStyleMapper(String html) {
        Document document = Jsoup.parse((String)html);
        Elements styles = document.getElementsByTag("style");
        StyleParser parser = new StyleParser();
        StyleMap mapper = new StyleMap(parser.parseStyleSheets(styles));
        return mapper;
    }

    protected boolean isNewSheet(Element element) {
        return Boolean.valueOf(element.attr(DATA_NEW_SHEET_ATTRIBUTE));
    }

    protected String getSheetName(Element element) {
        return element.attr(DATA_SHEET_NAME_ATTRIBUTE);
    }

    public abstract void exportHtml(String var1, OutputStream var2) throws IOException;
}

