/*
 * Decompiled with CFR 0.152.
 */
package uk.co.certait.htmlexporter.ss;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.list.GrowthList;
import uk.co.certait.htmlexporter.ss.TableCellReference;

public class CellRangeRow {
    private int index;
    private List<TableCellReference> cells;

    protected CellRangeRow(int index) {
        this.index = index;
        this.cells = GrowthList.decorate(new ArrayList());
    }

    public void addCell(TableCellReference cell) {
        if (cell == null) {
            throw new IllegalArgumentException();
        }
        if (this.cells.size() > cell.getColumnIndex()) {
            this.cells.remove(cell.getColumnIndex());
        }
        this.cells.add(cell.getColumnIndex(), cell);
    }

    protected boolean isContiguous() {
        boolean isContiguous = true;
        if (!this.cells.isEmpty()) {
            int firstPopulatedColumn = this.getFirstPopulatedColumn();
            int lastPopulatedColumn = this.getLastPopulatedColumn();
            for (int i = firstPopulatedColumn; i < lastPopulatedColumn; ++i) {
                if (this.cells.get(i) != null) continue;
                isContiguous = false;
                break;
            }
        } else {
            isContiguous = false;
        }
        return isContiguous;
    }

    protected int getFirstPopulatedColumn() {
        int firstColumn = -1;
        for (int i = 0; i < this.cells.size(); ++i) {
            if (this.cells.get(i) == null) continue;
            firstColumn = i;
            break;
        }
        return firstColumn;
    }

    protected int getLastPopulatedColumn() {
        int lastColumn = -1;
        for (int i = this.cells.size() - 1; i > -1; --i) {
            if (this.cells.get(i) == null) continue;
            lastColumn = i;
            break;
        }
        return lastColumn;
    }

    public boolean isEmpty() {
        boolean isEmpty = true;
        for (TableCellReference cell : this.cells) {
            if (cell == null) continue;
            isEmpty = false;
            break;
        }
        return isEmpty;
    }

    public int getWidth() {
        int width = 0;
        if (!this.isEmpty()) {
            width = this.getLastPopulatedColumn() - this.getFirstPopulatedColumn() + 1;
        }
        return width;
    }

    public List<TableCellReference> getCells() {
        return this.cells;
    }

    public TableCellReference getFirstCell() {
        return this.cells.get(this.getFirstPopulatedColumn());
    }

    public TableCellReference getLastCell() {
        return this.cells.get(this.getLastPopulatedColumn());
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (TableCellReference cell : this.cells) {
            if (cell != null) {
                builder.append("[").append(cell.getRowIndex()).append(",").append(cell.getColumnIndex()).append("]");
                continue;
            }
            builder.append("[x]");
        }
        return builder.toString();
    }
}

