/*
 * Decompiled with CFR 0.152.
 */
package uk.co.certait.htmlexporter.ss;

import java.util.ArrayList;
import java.util.List;
import uk.co.certait.htmlexporter.ss.CellRangeObserver;
import uk.co.certait.htmlexporter.ss.CellRangeRow;
import uk.co.certait.htmlexporter.ss.TableCellReference;

public class CellRange {
    private List<CellRangeRow> rows = new ArrayList<CellRangeRow>();
    private List<CellRangeObserver> listeners = new ArrayList<CellRangeObserver>();

    public void addCell(TableCellReference cell) {
        if (this.rows.size() == 0) {
            this.rows.add(new CellRangeRow(cell.getRowIndex()));
        } else if (this.isCellInNewRow(cell)) {
            int lastRowIndex;
            for (int i = lastRowIndex = this.rows.get(this.rows.size() - 1).getIndex(); i < cell.getRowIndex(); ++i) {
                this.rows.add(new CellRangeRow(i + 1));
            }
        }
        this.rows.get(this.rows.size() - 1).addCell(cell);
        this.notifyObservers();
    }

    public void addCellRangeObserver(CellRangeObserver listener) {
        this.listeners.add(listener);
    }

    private void notifyObservers() {
        for (CellRangeObserver listener : this.listeners) {
            listener.cellRangeUpdated(this);
        }
    }

    protected boolean isCellInNewRow(TableCellReference cell) {
        boolean isNewRow = true;
        for (CellRangeRow row : this.rows) {
            if (cell.getRowIndex() != row.getIndex()) continue;
            isNewRow = false;
        }
        return isNewRow;
    }

    public boolean isContiguous() {
        boolean isContiguous = true;
        int firstColumn = -99;
        int lastColumn = -99;
        boolean firstLoop = true;
        for (CellRangeRow row : this.rows) {
            if (!row.isContiguous()) {
                isContiguous = false;
                break;
            }
            if (!firstLoop) {
                if (row.getFirstPopulatedColumn() == firstColumn && row.getLastPopulatedColumn() == lastColumn) continue;
                isContiguous = false;
                break;
            }
            firstColumn = row.getFirstPopulatedColumn();
            lastColumn = row.getLastPopulatedColumn();
            firstLoop = false;
        }
        return isContiguous;
    }

    public int getHeight() {
        return this.rows.size();
    }

    public boolean isEmpty() {
        boolean isEmpty = true;
        for (CellRangeRow row : this.rows) {
            if (row.isEmpty()) continue;
            isEmpty = false;
            break;
        }
        return isEmpty;
    }

    public TableCellReference getFirstCell() {
        return this.rows.get(0).getFirstCell();
    }

    public TableCellReference getLastCell() {
        return this.rows.get(this.rows.size() - 1).getLastCell();
    }

    public List<CellRangeRow> getRows() {
        return this.rows;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (CellRangeRow row : this.rows) {
            builder.append("\nIndex").append(row.getIndex()).append(": ");
            builder.append(row.toString()).append("\n");
        }
        return builder.toString();
    }
}

