/*
 * Decompiled with CFR 0.152.
 */
package uk.co.certait.htmlexporter.demo.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.co.certait.htmlexporter.demo.domain.ProductGroup;
import uk.co.certait.htmlexporter.demo.domain.Sale;

public class Store {
    private String id;
    private String name;
    private Map<ProductGroup, List<Sale>> sales;

    public Store(String id, String name) {
        this.id = id;
        this.name = name;
        this.sales = new HashMap<ProductGroup, List<Sale>>();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Map<ProductGroup, List<Sale>> getSales() {
        return this.sales;
    }

    public void addSale(Sale sale) {
        if (!this.sales.containsKey((Object)sale.getProductGroup())) {
            this.sales.put(sale.getProductGroup(), new ArrayList());
        }
        this.sales.get((Object)sale.getProductGroup()).add(sale);
    }

    public int getNumberOfSalesForProductGroup(ProductGroup group) {
        return this.sales.containsKey((Object)group) ? this.sales.get((Object)group).size() : 0;
    }

    public BigDecimal getValueOfSalesForProductGroup(ProductGroup group) {
        BigDecimal total = new BigDecimal("0");
        if (this.sales.containsKey((Object)group)) {
            for (Sale sale : this.sales.get((Object)group)) {
                total = total.add(sale.getValue());
            }
        }
        return total;
    }

    public int getNumberOfSales() {
        int total = 0;
        for (ProductGroup group : this.sales.keySet()) {
            total += this.sales.get((Object)group).size();
        }
        return total;
    }

    public BigDecimal getValueOfSales() {
        BigDecimal total = new BigDecimal("0");
        for (ProductGroup group : this.sales.keySet()) {
            total = total.add(this.getValueOfSalesForProductGroup(group));
        }
        return total;
    }
}

