/*
 * Decompiled with CFR 0.152.
 */
package uk.co.certait.htmlexporter.demo.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import uk.co.certait.htmlexporter.demo.domain.ProductGroup;
import uk.co.certait.htmlexporter.demo.domain.Region;
import uk.co.certait.htmlexporter.demo.domain.Store;

public class Area {
    private int id;
    private String name;
    private List<Region> regions;

    public Area(int id, String name) {
        this.id = id;
        this.name = name;
        this.regions = new ArrayList<Region>();
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<Region> getRegions() {
        return this.regions;
    }

    public void addRegion(Region region) {
        this.regions.add(region);
    }

    public int getNumberOfSalesForProductGroup(ProductGroup group) {
        int count = 0;
        for (Region region : this.regions) {
            count += region.getNumberOfSalesForProductGroup(group);
        }
        return count;
    }

    public BigDecimal getValueOfSalesForProductGroup(ProductGroup group) {
        BigDecimal total = new BigDecimal("0");
        for (Region region : this.regions) {
            total = total.add(region.getValueOfSalesForProductGroup(group));
        }
        return total;
    }

    public Store getBestPerformingStoreForProductGroup(ProductGroup group) {
        Store store = null;
        BigDecimal maxSales = new BigDecimal("-1");
        for (Region region : this.regions) {
            for (Store s : region.getStores()) {
                if (s.getValueOfSalesForProductGroup(group).compareTo(maxSales) <= 0) continue;
                store = s;
                maxSales = store.getValueOfSalesForProductGroup(group);
            }
        }
        return store;
    }

    public int getNumberOfSales() {
        int total = 0;
        for (Region region : this.regions) {
            total += region.getNumberOfSales();
        }
        return total;
    }

    public BigDecimal getValueOfSales() {
        BigDecimal total = new BigDecimal("0");
        for (Region region : this.regions) {
            total = total.add(region.getValueOfSales());
        }
        return total;
    }

    public int getNumberOfRegions() {
        return this.regions.size();
    }

    public int getNumberOfStores() {
        int total = 0;
        for (Region region : this.regions) {
            total += region.getNumberOfStores();
        }
        return total;
    }
}

