/*
 * Decompiled with CFR 0.152.
 */
package uk.co.certait.htmlexporter.css;

import com.helger.commons.collection.impl.ICommonsList;
import com.helger.css.ECSSVersion;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSSelector;
import com.helger.css.decl.CSSStyleRule;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.decl.ICSSSelectorMember;
import com.helger.css.reader.CSSReader;
import java.util.HashMap;
import java.util.Map;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import uk.co.certait.htmlexporter.css.Style;
import uk.co.certait.htmlexporter.css.StyleGenerator;
import uk.co.certait.htmlexporter.css.StyleMerger;

public class StyleParser {
    private StyleGenerator generator = new StyleGenerator();

    public Map<String, Style> parseStyleSheets(Elements elements) {
        HashMap<String, Style> mergedStyleMap = new HashMap<String, Style>();
        for (Element element : elements) {
            Map<String, Style> styleMap = this.parseStyleSheet(element);
            for (Map.Entry<String, Style> entry : styleMap.entrySet()) {
                if (mergedStyleMap.containsKey(entry.getKey())) {
                    mergedStyleMap.put(entry.getKey(), StyleMerger.mergeStyles((Style)mergedStyleMap.get(entry.getKey()), entry.getValue()));
                    continue;
                }
                mergedStyleMap.put(entry.getKey(), entry.getValue());
            }
        }
        return mergedStyleMap;
    }

    public Map<String, Style> parseStyleSheet(Element element) {
        HashMap<String, Style> styleMap = new HashMap<String, Style>();
        CascadingStyleSheet sheet = CSSReader.readFromString((String)element.data(), (ECSSVersion)ECSSVersion.LATEST);
        ICommonsList rules = sheet.getAllStyleRules();
        for (CSSStyleRule rule : rules) {
            ICommonsList selectors = rule.getAllSelectors();
            ICommonsList declarations = rule.getAllDeclarations();
            for (CSSDeclaration declaration : declarations) {
                Style style = this.generator.createStyle(declaration);
                for (CSSSelector selector : selectors) {
                    ICommonsList selectorMembers = selector.getAllMembers();
                    for (ICSSSelectorMember selectorMember : selectorMembers) {
                        String selectorName = selectorMember.getAsCSSString();
                        if (styleMap.containsKey(selectorName)) {
                            styleMap.put(selectorName, StyleMerger.mergeStyles((Style)styleMap.get(selectorName), style));
                            continue;
                        }
                        styleMap.put(selectorName, style);
                    }
                }
            }
        }
        return styleMap;
    }
}

