/*
 * Decompiled with CFR 0.152.
 */
package uk.co.certait.htmlexporter.css;

import com.helger.commons.collection.impl.ICommonsList;
import com.helger.css.ECSSVersion;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSDeclarationList;
import com.helger.css.reader.CSSReaderDeclarationList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Element;
import uk.co.certait.htmlexporter.css.Style;
import uk.co.certait.htmlexporter.css.StyleGenerator;
import uk.co.certait.htmlexporter.css.StyleMerger;

public class StyleMap {
    private static final String CLASS_PREFIX = ".";
    Map<String, Style> styles;
    private StyleGenerator generator;

    public StyleMap(Map<String, Style> styles) {
        this.styles = styles != null ? styles : new HashMap();
        this.generator = new StyleGenerator();
    }

    public Style getStyleForElement(Element element) {
        return StyleMerger.mergeStyles(this.getAllStyles(element).toArray(new Style[0]));
    }

    protected List<Style> getAllStyles(Element element) {
        Optional<Style> inlineStyle;
        ArrayList<Style> styles = new ArrayList<Style>();
        if (this.getStyleForTag(element) != null) {
            styles.add(this.getStyleForTag(element));
        }
        if (!this.getStylesForClass(element).isEmpty()) {
            List<Style> classStyles = this.getStylesForClass(element);
            styles.addAll(classStyles);
        }
        if ((inlineStyle = this.getInlineStyle(element)).isPresent()) {
            styles.add(inlineStyle.get());
        }
        for (Element parent : element.parents()) {
            styles.addAll(0, this.getAllStyles(parent));
        }
        return styles;
    }

    private Style getStyleForTag(Element element) {
        return this.styles.get(element.tagName());
    }

    private List<Style> getStylesForClass(Element element) {
        ArrayList<Style> classStyles = new ArrayList<Style>();
        if (StringUtils.isNotEmpty((CharSequence)element.className())) {
            String[] classNames;
            for (String className : classNames = element.className().split(" ")) {
                String qualifiedClassName = CLASS_PREFIX + className.trim();
                if (!this.styles.containsKey(qualifiedClassName)) continue;
                classStyles.add(this.styles.get(qualifiedClassName));
            }
        }
        return classStyles;
    }

    protected Optional<Style> getInlineStyle(Element element) {
        ArrayList<Style> styles = new ArrayList<Style>();
        if (element.hasAttr("style")) {
            CSSDeclarationList cssStyles = CSSReaderDeclarationList.readFromString((String)element.attr("style"), (ECSSVersion)ECSSVersion.LATEST);
            ICommonsList declarations = cssStyles.getAllDeclarations();
            for (CSSDeclaration declaration : declarations) {
                styles.add(this.generator.createStyle(declaration));
            }
        }
        return Optional.of(StyleMerger.mergeStyles(styles.toArray(new Style[0])));
    }
}

