/*
 * Decompiled with CFR 0.152.
 */
package uk.co.certait.htmlexporter.css;

import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSExpressionMemberTermSimple;
import com.helger.css.decl.ICSSExpressionMember;
import com.helger.css.decl.shorthand.CSSShortHandDescriptor;
import com.helger.css.decl.shorthand.CSSShortHandRegistry;
import com.helger.css.property.ECSSProperty;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import uk.co.certait.htmlexporter.css.CssColorProperty;
import uk.co.certait.htmlexporter.css.CssIntegerProperty;
import uk.co.certait.htmlexporter.css.CssStringProperty;
import uk.co.certait.htmlexporter.css.Style;
import uk.co.certait.htmlexporter.css.StyleMerger;

public class StyleGenerator {
    private static final String PX = "px";
    private static final String PERCENTAGE = "%";

    protected Style createStyle(CSSDeclaration declaration) {
        ArrayList<Style> styles = new ArrayList<Style>();
        ArrayList<CSSDeclaration> declarations = new ArrayList<CSSDeclaration>();
        if (ECSSProperty.getFromNameOrNull((String)declaration.getProperty()) != null) {
            CSSShortHandDescriptor shorthandDescriptor = CSSShortHandRegistry.getShortHandDescriptor((ECSSProperty)ECSSProperty.getFromNameOrNull((String)declaration.getProperty()));
            if (shorthandDescriptor != null) {
                declarations.addAll((Collection<CSSDeclaration>)shorthandDescriptor.getSplitIntoPieces(declaration));
            } else {
                declarations.add(declaration);
            }
            for (CSSDeclaration decs : declarations) {
                Style style = new Style();
                this.populateIntegerProperties(decs, style);
                this.populateStringProperties(decs, style);
                this.populateColorProperties(decs, style);
                styles.add(style);
            }
        }
        return StyleMerger.mergeStyles(styles.toArray(new Style[0]));
    }

    protected void populateIntegerProperties(CSSDeclaration rule, Style style) {
        for (CssIntegerProperty p : CssIntegerProperty.values()) {
            ICSSExpressionMember member;
            CSSExpressionMemberTermSimple term;
            if (!p.getProperty().equals(rule.getProperty()) || (term = (CSSExpressionMemberTermSimple)(member = rule.getExpression().getMemberAtIndex(0))).getValue().contains(PERCENTAGE)) continue;
            double value = Double.parseDouble(term.getValue().replaceAll(PX, "").trim());
            if (value < 1.0) {
                value = 1.0;
            }
            style.addProperty(p, (int)value);
        }
    }

    protected void populateStringProperties(CSSDeclaration rule, Style style) {
        for (CssStringProperty p : CssStringProperty.values()) {
            if (!p.getProperty().equals(rule.getProperty())) continue;
            ICSSExpressionMember member = rule.getExpression().getMemberAtIndex(0);
            CSSExpressionMemberTermSimple term = (CSSExpressionMemberTermSimple)member;
            style.addProperty(p, term.getValue().trim());
        }
    }

    protected void populateColorProperties(CSSDeclaration rule, Style style) {
        for (CssColorProperty p : CssColorProperty.values()) {
            if (!p.getProperty().equals(rule.getProperty())) continue;
            ICSSExpressionMember member = rule.getExpression().getMemberAtIndex(0);
            CSSExpressionMemberTermSimple term = (CSSExpressionMemberTermSimple)member;
            style.addProperty(p, this.createColor(term.getValue().trim()));
        }
    }

    private Color createColor(String cssValue) {
        try {
            return Color.decode(cssValue.toUpperCase());
        }
        catch (Exception ex) {
            try {
                Field field = Class.forName("java.awt.Color").getField(cssValue.toUpperCase());
                return (Color)field.get(null);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

